/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2004, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

    Module Name:
	rtusb.h

    Abstract:
    Miniport generic portion header file

    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------

*/
#ifndef __RTMP_H__
#define __RTMP_H__
//
//  NDIS Version definitions
//
#ifdef  NDIS50_MINIPORT
#define RTMP_NDIS_MAJOR_VERSION     5
#define RTMP_NDIS_MINOR_VERSION     0
#endif

#ifdef  NDIS51_MINIPORT
#define RTMP_NDIS_MAJOR_VERSION     5
#define RTMP_NDIS_MINOR_VERSION     1
#endif

extern  char    NIC_VENDOR_DESC[];
extern  int     NIC_VENDOR_DESC_LEN;

extern  unsigned long   NIC_VENDOR_DRIVER_VERSION;
//extern    unsigned short  NIC_PCI_DEVICE_ID;
extern  unsigned short  NIC2661_PCI_DEVICE_ID;
extern  unsigned short  NIC2561_PCI_DEVICE_ID;
extern  unsigned short  NIC2561Turbo_PCI_DEVICE_ID;
extern  unsigned short  NIC_PCI_VENDOR_ID;
extern  unsigned char   SNAP_AIRONET[];
extern  unsigned char   CipherSuiteCiscoCCKM[];
extern  unsigned char   CipherSuiteCiscoCCKMLen;
extern	unsigned char	CipherSuiteCiscoCCKM24[];
extern	unsigned char	CipherSuiteCiscoCCKM24Len;
extern  unsigned char   CipherSuiteCiscoCCKMTkip[];
extern  unsigned char   CipherSuiteCiscoCCKMTkipLen;
extern	unsigned char	CipherSuiteCiscoCCKMTkip24[];
extern	unsigned char	CipherSuiteCiscoCCKMTkip24Len;
extern  unsigned char   CipherSuiteCCXTkip[];
extern  unsigned char   CipherSuiteCCXTkipLen;
extern  unsigned char   CISCO_OUI[];

extern UCHAR BROADCAST_ADDR[MAC_ADDR_LEN];
extern UCHAR ZERO_MAC_ADDR[MAC_ADDR_LEN];
extern ULONG BIT32[32];
extern UCHAR BIT8[8];
extern char* CipherName[];

extern UCHAR SNAP_802_1H[6];
extern UCHAR SNAP_BRIDGE_TUNNEL[6];
extern UCHAR SNAP_AIRONET[8];
extern UCHAR CKIP_LLC_SNAP[8];
extern UCHAR EAPOL_LLC_SNAP[8];
extern UCHAR EAPOL[2];
extern UCHAR IPX[2];
extern UCHAR APPLE_TALK[2];
extern UCHAR RateIdToPlcpSignal[12]; // see IEEE802.11a-1999 p.14
extern UCHAR OfdmSignalToRateId[16] ;
extern UCHAR default_cwmin[4];
extern UCHAR default_cwmax[4];
extern UCHAR default_sta_aifsn[4];
extern UCHAR MapUserPriorityToAccessCategory[8];

extern USHORT RateUpPER[];
extern USHORT RateDownPER[];
extern UCHAR  Phy11BNextRateDownward[];
extern UCHAR  Phy11BNextRateUpward[];
extern UCHAR  Phy11BGNextRateDownward[];
extern UCHAR  Phy11BGNextRateUpward[];
extern UCHAR  Phy11ANextRateDownward[];
extern UCHAR  Phy11ANextRateUpward[];
extern CHAR   RssiSafeLevelForTxRate[];
extern UCHAR  RateIdToMbps[];
extern USHORT RateIdTo500Kbps[];

extern UCHAR  CipherSuiteWpaNoneTkip[];
extern UCHAR  CipherSuiteWpaNoneTkipLen;

extern UCHAR  CipherSuiteWpaNoneAes[];
extern UCHAR  CipherSuiteWpaNoneAesLen;

extern UCHAR  SsidIe;
extern UCHAR  SupRateIe;
extern UCHAR  ExtRateIe;
extern UCHAR  ErpIe;
extern UCHAR  DsIe;
extern UCHAR  TimIe;
extern UCHAR  WpaIe;
extern UCHAR  Wpa2Ie;
extern UCHAR  IbssIe;
extern UCHAR  Ccx2Ie;

extern UCHAR  WPA_OUI[];
extern UCHAR  WME_INFO_ELEM[];
extern UCHAR  WME_PARM_ELEM[];
extern UCHAR  Ccx2QosInfo[];
extern UCHAR  Ccx2IeInfo[];
extern UCHAR  RALINK_OUI[];

//
//  Queue structure and macros
//
typedef struct  _QUEUE_ENTRY    {
	struct _QUEUE_ENTRY     *Next;
}   QUEUE_ENTRY, *PQUEUE_ENTRY;

// Queue structure
typedef struct  _QUEUE_HEADER   {
	PQUEUE_ENTRY    Head;
	PQUEUE_ENTRY    Tail;
	ULONG           Number;
}   QUEUE_HEADER, *PQUEUE_HEADER;

#define InitializeQueueHeader(QueueHeader)              \
{                                                       \
	(QueueHeader)->Head = (QueueHeader)->Tail = NULL;   \
	(QueueHeader)->Number = 0;                          \
}

#define RemoveHeadQueue(QueueHeader)                \
(QueueHeader)->Head;                                \
{                                                   \
	PQUEUE_ENTRY pNext;                             \
	if ((QueueHeader)->Head != NULL)				\
	{												\
		pNext = (QueueHeader)->Head->Next;          \
		(QueueHeader)->Head = pNext;                \
		if (pNext == NULL)                          \
			(QueueHeader)->Tail = NULL;             \
		(QueueHeader)->Number--;                    \
	}												\
}

#define InsertHeadQueue(QueueHeader, QueueEntry)            \
{                                                           \
	((PQUEUE_ENTRY)QueueEntry)->Next = (QueueHeader)->Head; \
	(QueueHeader)->Head = (PQUEUE_ENTRY)(QueueEntry);       \
	if ((QueueHeader)->Tail == NULL)                        \
		(QueueHeader)->Tail = (PQUEUE_ENTRY)(QueueEntry);   \
	(QueueHeader)->Number++;                                \
}

#define InsertTailQueue(QueueHeader, QueueEntry)                \
{                                                               \
	((PQUEUE_ENTRY)QueueEntry)->Next = NULL;                    \
	if ((QueueHeader)->Tail)                                    \
		(QueueHeader)->Tail->Next = (PQUEUE_ENTRY)(QueueEntry); \
	else                                                        \
		(QueueHeader)->Head = (PQUEUE_ENTRY)(QueueEntry);       \
	(QueueHeader)->Tail = (PQUEUE_ENTRY)(QueueEntry);           \
	(QueueHeader)->Number++;                                    \
}

//
//  Macros for flag and ref count operations
//
#define RTMP_SET_FLAG(_M, _F)       ((_M)->Flags |= (_F))
#define RTMP_CLEAR_FLAG(_M, _F)     ((_M)->Flags &= ~(_F))
#define RTMP_CLEAR_FLAGS(_M)        ((_M)->Flags = 0)
#define RTMP_TEST_FLAG(_M, _F)      (((_M)->Flags & (_F)) != 0)
#define RTMP_TEST_FLAGS(_M, _F)     (((_M)->Flags & (_F)) == (_F))

// Flags control for RT2500 USB bulk out frame type
#define RTUSB_SET_BULK_FLAG(_M, _F)				((_M)->BulkFlags |= (_F))
#define RTUSB_CLEAR_BULK_FLAG(_M, _F)			((_M)->BulkFlags &= ~(_F))
#define RTUSB_TEST_BULK_FLAG(_M, _F)			(((_M)->BulkFlags & (_F)) != 0)

#define OPSTATUS_SET_FLAG(_pAd, _F)     ((_pAd)->CommonCfg.OpStatusFlags |= (_F))
#define OPSTATUS_CLEAR_FLAG(_pAd, _F)   ((_pAd)->CommonCfg.OpStatusFlags &= ~(_F))
#define OPSTATUS_TEST_FLAG(_pAd, _F)    (((_pAd)->CommonCfg.OpStatusFlags & (_F)) != 0)

#define CLIENT_STATUS_SET_FLAG(_pEntry,_F)      ((_pEntry)->ClientStatusFlags |= (_F))
#define CLIENT_STATUS_CLEAR_FLAG(_pEntry,_F)    ((_pEntry)->ClientStatusFlags &= ~(_F))
#define CLIENT_STATUS_TEST_FLAG(_pEntry,_F)     (((_pEntry)->ClientStatusFlags & (_F)) != 0)

//#define STACFG_SET_FLAG(_pAd, _F)       ((_pAd)->StaCfg.StaCfgFlags |= (_F))
//#define STACFG_CLEAR_FLAG(_pAd, _F)     ((_pAd)->StaCfg.StaCfgFlags &= ~(_F))
//#define STACFG_TEST_FLAG(_pAd, _F)      (((_pAd)->StaCfg.StaCfgFlags & (_F)) != 0)

#define RX_FILTER_SET_FLAG(_pAd, _F)    ((_pAd)->CommonCfg.PacketFilter |= (_F))
#define RX_FILTER_CLEAR_FLAG(_pAd, _F)  ((_pAd)->CommonCfg.PacketFilter &= ~(_F))
#define RX_FILTER_TEST_FLAG(_pAd, _F)   (((_pAd)->CommonCfg.PacketFilter & (_F)) != 0)

#define PRIVATE_SET_STATUS(_pAd, _F)     ((_pAd)->CommonCfg.PrivateMessage |= (_F))
#define PRIVATE_CLEAR_STATUS(_pAd, _F)   ((_pAd)->CommonCfg.PrivateMessage &= ~(_F))
#define PRIVATE_TEST_STATUS(_pAd, _F)    (((_pAd)->CommonCfg.PrivateMessage & (_F)) != 0)

#define RTMP_INC_RCV_REF(_A)        ((_A)->RcvRefCount++)
#define RTMP_DEC_RCV_REF(_A)        ((_A)->RcvRefCount--)
#define RTMP_GET_RCV_REF(_A)        ((_A)->RcvRefCount)

//#define RTMP_INC_SEND_REF(_A)       ((_A)->SendRefCount++)
//#define RTMP_DEC_SEND_REF(_A)       ((_A)->SendRefCount--)
//#define RTMP_GET_SEND_REF(_A)       ((_A)->SendRefCount)

#define RTMP_OFFSET(field)          ((UINT)FIELD_OFFSET(RTMP_ADAPTER, field))
#define RTMP_SIZE(field)            sizeof(((PRTMP_ADAPTER)0)->field)
//#define PORT_OFFSET(field)          ((UINT)FIELD_OFFSET(STA_ADMIN_CONFIG, field))
//#define PORT_SIZE(field)            sizeof(((PSTA_ADMIN_CONFIG)0)->field)

#define COMMON_CFG_OFFSET(field)    ((UINT)FIELD_OFFSET(RTMP_ADAPTER, CommonCfg) + (UINT)FIELD_OFFSET(COMMON_CONFIG, field))
#define STA_CFG_OFFSET(field)       ((UINT)FIELD_OFFSET(RTMP_ADAPTER, StaCfg) + (UINT)FIELD_OFFSET(STA_ADMIN_CONFIG, field))
#define AP_CFG_OFFSET(field)        ((UINT)FIELD_OFFSET(RTMP_ADAPTER, ApCfg) + (UINT)FIELD_OFFSET(AP_ADMIN_CONFIG, field))
#define COMMON_CFG_SIZE(field)      sizeof(((PCOMMON_CONFIG)0)->field)
#define STA_CFG_SIZE(field)         sizeof(((PSTA_ADMIN_CONFIG)0)->field)
#define AP_CFG_SIZE(field)          sizeof(((PAP_ADMIN_CONFIG)0)->field)

#define INC_RING_INDEX(_idx, _RingSize)    \
{                                          \
	(_idx)++;                              \
	if ((_idx) >= (_RingSize)) _idx=0;     \
}

// Increase TxTsc value for next transmission
// TODO:
// When i==6, means TSC has done one full cycle, do re-keying stuff follow specs
// Should send a special event microsoft defined to request re-key
#define INC_TX_TSC(_tsc)                                \
{                                                       \
	int i=0;                                            \
	while (++_tsc[i] == 0x0)                            \
	{                                                   \
		i++;                                            \
		if (i == 6)                                     \
			break;                                      \
	}                                                   \
}

#if defined(ME_98) && (ME_98 == 1)
//
// Re-define NdisInitializeString.
// Since the DDK NdisInitializeString is not support on Win9X
//
#define NdisInitializeString(Destination,Source)                                 \
{                                                                                \
	NDIS_PHYSICAL_ADDRESS phyaddr= {-1,-1};                                      \
	PNDIS_STRING _D = (Destination);                                             \
	UCHAR *_S = (Source);                                                        \
	WCHAR *_P;                                                                   \
	_D->Length = (strlen(_S)) * sizeof(WCHAR);                                   \
	_D->MaximumLength = _D->Length + sizeof(WCHAR);                              \
	NdisAllocateMemory((PVOID *)&(_D->Buffer), _D->MaximumLength, 0, phyaddr);   \
	_P = _D->Buffer;                                                             \
	while(*_S != '\0'){                                                          \
		*_P = (WCHAR)(*_S);                                                      \
		_S++;                                                                    \
		_P++;                                                                    \
	}                                                                            \
	*_P = UNICODE_NULL;                                                          \
}
#endif

#define     MAP_CHANNEL_ID_TO_KHZ(ch, khz)  {               \
				switch (ch)                                 \
				{                                           \
					case 1:     khz = 2412000;   break;     \
					case 2:     khz = 2417000;   break;     \
					case 3:     khz = 2422000;   break;     \
					case 4:     khz = 2427000;   break;     \
					case 5:     khz = 2432000;   break;     \
					case 6:     khz = 2437000;   break;     \
					case 7:     khz = 2442000;   break;     \
					case 8:     khz = 2447000;   break;     \
					case 9:     khz = 2452000;   break;     \
					case 10:    khz = 2457000;   break;     \
					case 11:    khz = 2462000;   break;     \
					case 12:    khz = 2467000;   break;     \
					case 13:    khz = 2472000;   break;     \
					case 14:    khz = 2484000;   break;     \
					case 36:  /* UNII */  khz = 5180000;   break;     \
					case 40:  /* UNII */  khz = 5200000;   break;     \
					case 44:  /* UNII */  khz = 5220000;   break;     \
					case 48:  /* UNII */  khz = 5240000;   break;     \
					case 52:  /* UNII */  khz = 5260000;   break;     \
					case 56:  /* UNII */  khz = 5280000;   break;     \
					case 60:  /* UNII */  khz = 5300000;   break;     \
					case 64:  /* UNII */  khz = 5320000;   break;     \
					case 149: /* UNII */  khz = 5745000;   break;     \
					case 153: /* UNII */  khz = 5765000;   break;     \
					case 157: /* UNII */  khz = 5785000;   break;     \
					case 161: /* UNII */  khz = 5805000;   break;     \
					case 165: /* UNII */  khz = 5825000;   break;     \
					case 100: /* HiperLAN2 */  khz = 5500000;   break;     \
					case 104: /* HiperLAN2 */  khz = 5520000;   break;     \
					case 108: /* HiperLAN2 */  khz = 5540000;   break;     \
					case 112: /* HiperLAN2 */  khz = 5560000;   break;     \
					case 116: /* HiperLAN2 */  khz = 5580000;   break;     \
					case 120: /* HiperLAN2 */  khz = 5600000;   break;     \
					case 124: /* HiperLAN2 */  khz = 5620000;   break;     \
					case 128: /* HiperLAN2 */  khz = 5640000;   break;     \
					case 132: /* HiperLAN2 */  khz = 5660000;   break;     \
					case 136: /* HiperLAN2 */  khz = 5680000;   break;     \
					case 140: /* HiperLAN2 */  khz = 5700000;   break;     \
					case 34:  /* Japan MMAC */   khz = 5170000;   break;   \
					case 38:  /* Japan MMAC */   khz = 5190000;   break;   \
					case 42:  /* Japan MMAC */   khz = 5210000;   break;   \
					case 46:  /* Japan MMAC */   khz = 5230000;   break;   \
					default:    khz = 2412000;   break;     \
				}                                           \
			}

#define     MAP_KHZ_TO_CHANNEL_ID(khz, ch)  {               \
				switch (khz)                                \
				{                                           \
					case 2412000:    ch = 1;     break;     \
					case 2417000:    ch = 2;     break;     \
					case 2422000:    ch = 3;     break;     \
					case 2427000:    ch = 4;     break;     \
					case 2432000:    ch = 5;     break;     \
					case 2437000:    ch = 6;     break;     \
					case 2442000:    ch = 7;     break;     \
					case 2447000:    ch = 8;     break;     \
					case 2452000:    ch = 9;     break;     \
					case 2457000:    ch = 10;    break;     \
					case 2462000:    ch = 11;    break;     \
					case 2467000:    ch = 12;    break;     \
					case 2472000:    ch = 13;    break;     \
					case 2484000:    ch = 14;    break;     \
					case 5180000:    ch = 36;  /* UNII */  break;     \
					case 5200000:    ch = 40;  /* UNII */  break;     \
					case 5220000:    ch = 44;  /* UNII */  break;     \
					case 5240000:    ch = 48;  /* UNII */  break;     \
					case 5260000:    ch = 52;  /* UNII */  break;     \
					case 5280000:    ch = 56;  /* UNII */  break;     \
					case 5300000:    ch = 60;  /* UNII */  break;     \
					case 5320000:    ch = 64;  /* UNII */  break;     \
					case 5745000:    ch = 149; /* UNII */  break;     \
					case 5765000:    ch = 153; /* UNII */  break;     \
					case 5785000:    ch = 157; /* UNII */  break;     \
					case 5805000:    ch = 161; /* UNII */  break;     \
					case 5825000:    ch = 165; /* UNII */  break;     \
					case 5500000:    ch = 100; /* HiperLAN2 */  break;     \
					case 5520000:    ch = 104; /* HiperLAN2 */  break;     \
					case 5540000:    ch = 108; /* HiperLAN2 */  break;     \
					case 5560000:    ch = 112; /* HiperLAN2 */  break;     \
					case 5580000:    ch = 116; /* HiperLAN2 */  break;     \
					case 5600000:    ch = 120; /* HiperLAN2 */  break;     \
					case 5620000:    ch = 124; /* HiperLAN2 */  break;     \
					case 5640000:    ch = 128; /* HiperLAN2 */  break;     \
					case 5660000:    ch = 132; /* HiperLAN2 */  break;     \
					case 5680000:    ch = 136; /* HiperLAN2 */  break;     \
					case 5700000:    ch = 140; /* HiperLAN2 */  break;     \
					case 5170000:    ch = 34;  /* Japan MMAC */   break;   \
					case 5190000:    ch = 38;  /* Japan MMAC */   break;   \
					case 5210000:    ch = 42;  /* Japan MMAC */   break;   \
					case 5230000:    ch = 46;  /* Japan MMAC */   break;   \
					default:         ch = 1;     break;     \
				}                                           \
			}

//
// Common fragment list structure -  Identical to the scatter gather frag list structure
//
//#define RTMP_SCATTER_GATHER_ELEMENT         SCATTER_GATHER_ELEMENT
//#define PRTMP_SCATTER_GATHER_ELEMENT        PSCATTER_GATHER_ELEMENT
#define NIC_MAX_PHYS_BUF_COUNT              8

typedef struct _RTMP_SCATTER_GATHER_ELEMENT {
	PVOID		Address;
	ULONG		Length;
	PULONG		Reserved;
} RTMP_SCATTER_GATHER_ELEMENT, *PRTMP_SCATTER_GATHER_ELEMENT;

typedef struct _RTMP_SCATTER_GATHER_LIST {
	ULONG  NumberOfElements;
	PULONG Reserved;
	RTMP_SCATTER_GATHER_ELEMENT Elements[NIC_MAX_PHYS_BUF_COUNT];
} RTMP_SCATTER_GATHER_LIST, *PRTMP_SCATTER_GATHER_LIST;

//
//  Some utility macros
//
#ifndef min
#define min(_a, _b)     (((_a) < (_b)) ? (_a) : (_b))
#endif

#ifndef max
#define max(_a, _b)     (((_a) > (_b)) ? (_a) : (_b))
#endif

#define INC_COUNTER64(Val)          (Val.QuadPart++)

#define INFRA_ON(_p)                (OPSTATUS_TEST_FLAG(_p, fOP_STATUS_INFRA_ON))
#define ADHOC_ON(_p)                (OPSTATUS_TEST_FLAG(_p, fOP_STATUS_ADHOC_ON))

// Check LEAP & CCKM flags
#define LEAP_ON(_p)                 (((_p)->StaCfg.LeapAuthMode) == CISCO_AuthModeLEAP)
#define LEAP_CCKM_ON(_p)            ((((_p)->StaCfg.LeapAuthMode) == CISCO_AuthModeLEAP) && ((_p)->StaCfg.LeapAuthInfo.CCKM == TRUE))
//#define LEAP_CKIP_KP_ON(_p)			((((_p)->StaCfg.LeapAuthMode) == CISCO_AuthModeLEAP) && (((_p)->StaCfg.CkipFlag) & 0x10))
#define CKIP_KP_ON(_p)				((((_p)->StaCfg.CkipFlag) & 0x10) && ((_p)->StaCfg.bCkipCmicOn == TRUE))
#define CKIP_CMIC_ON(_p)			((((_p)->StaCfg.CkipFlag) & 0x08) && ((_p)->StaCfg.bCkipCmicOn == TRUE))

// NOTE: 2004-12-1 John
//   check DDK NDIS_PACKET data structure and find out only MiniportReservedEx[0..7] can be used by our driver without
//   ambiguity. Fields after pPacket->MiniportReservedEx[8] may be used by other wrapper layer thus crashes the driver
//
//#define RTMP_GET_PACKET_MR(_p)                  (&(_p)->MiniportReservedEx[0])

// b0-b3 as User Priority
//#define RTMP_SET_PACKET_UP(_p, _prio)           ((_p)->MiniportReservedEx[sizeof(PVOID)] = ((_p)->MiniportReservedEx[sizeof(PVOID)] & 0xf0) | (_prio))
//#define RTMP_GET_PACKET_UP(_p)                  ((_p)->MiniportReservedEx[sizeof(PVOID)] & 0x0f)

// b4-b7 as fragment #
//#define RTMP_SET_PACKET_FRAGMENTS(_p, _num)     ((_p)->MiniportReservedEx[sizeof(PVOID)] = ((_p)->MiniportReservedEx[sizeof(PVOID)] & 0x0f) | (_num << 4))
//#define RTMP_GET_PACKET_FRAGMENTS(_p)           (((_p)->MiniportReservedEx[sizeof(PVOID)] & 0xf0) >> 4)

// 0x0 ~0x7f: TX to AP's own BSS which has the specified AID (this value also as MAC table index)
// 0x80~0xff: TX to a WDS link. b0~6: WDS index
//#define RTMP_SET_PACKET_WDS(_p, _wdsidx)        ((_p)->MiniportReservedEx[sizeof(PVOID) + 1] = _wdsidx)
//#define RTMP_GET_PACKET_WDS(_p)                 ((_p)->MiniportReservedEx[sizeof(PVOID) + 1])

// 0xff: PKTSRC_NDIS, others: local TX buffer index. This value affects how to a packet
//#define RTMP_SET_PACKET_SOURCE(_p, _pktsrc)     ((_p)->MiniportReservedEx[sizeof(PVOID) + 2] = _pktsrc)
//#define RTMP_GET_PACKET_SOURCE(_p)              ((_p)->MiniportReservedEx[sizeof(PVOID) + 2])

// b0~2: RTS/CTS-to-self protection method
//#define RTMP_SET_PACKET_RTS(_p, _num)           ((_p)->MiniportReservedEx[sizeof(PVOID) + 3] = ((_p)->MiniportReservedEx[sizeof(PVOID) + 3] & 0xf8) | (_num))
//#define RTMP_GET_PACKET_RTS(_p)                 ((_p)->MiniportReservedEx[sizeof(PVOID) + 3] & 0x07)

// b3~7: TX rate index
//#define RTMP_SET_PACKET_TXRATE(_p, _rate)       ((_p)->MiniportReservedEx[sizeof(PVOID) + 3] = ((_p)->MiniportReservedEx[sizeof(PVOID) + 3] & 0x07) | (_rate << 3))
//#define RTMP_GET_PACKET_TXRATE(_p)              (((_p)->MiniportReservedEx[sizeof(PVOID) + 3] & 0xf8) >> 3)

// value recorded inside pNdisPacket->MiniportReservedEx[x] via RTMP_SET_PACKET_SOURCE()/RTMP_GET_PACKET_SOURCE()
// this value is used to decide how to release this NDIS packet - either release to NDIS layer or release
// to driver's pre-allocated packet pool
//      0xff: NDIS PACKET is pass from Windows NDIS layer
//      0 ~ NUM_OF_PREALLOCATEDP_SHARED_MEMORY: NDIS PACKET is created internally
//#define PKTSRC_NDIS             0xff

#define MAKE_802_3_HEADER(_p, _pMac1, _pMac2, _pType)                   \
{                                                                       \
	NdisMoveMemory(_p, _pMac1, MAC_ADDR_LEN);                           \
	NdisMoveMemory((_p + MAC_ADDR_LEN), _pMac2, MAC_ADDR_LEN);          \
	NdisMoveMemory((_p + MAC_ADDR_LEN * 2), _pType, LENGTH_802_3_TYPE); \
}

// if pData has no LLC/SNAP (neither RFC1042 nor Bridge tunnel), keep it that way.
// else if the received frame is LLC/SNAP-encaped IPX or APPLETALK, preserve the LLC/SNAP field
// else remove the LLC/SNAP field from the result Ethernet frame
// Patch for WHQL only, which did not turn on Netbios but use IPX within its payload
// Note:
//     _pData & _DataSize may be altered (remove 8-byte LLC/SNAP) by this MACRO
//     _pRemovedLLCSNAP: pointer to removed LLC/SNAP; NULL is not removed
#define CONVERT_TO_802_3(_p8023hdr, _pDA, _pSA, _pData, _DataSize, _pRemovedLLCSNAP)      \
{                                                                       \
	char LLC_Len[2];                                                    \
																		\
	_pRemovedLLCSNAP = NULL;                                            \
	if (NdisEqualMemory(SNAP_802_1H, _pData, 6)  ||                     \
		NdisEqualMemory(SNAP_BRIDGE_TUNNEL, _pData, 6))                 \
	{                                                                   \
		PUCHAR pProto = _pData + 6;                                     \
																		\
		if ((NdisEqualMemory(IPX, pProto, 2) || NdisEqualMemory(APPLE_TALK, pProto, 2)) &&  \
			NdisEqualMemory(SNAP_802_1H, _pData, 6))                    \
		{                                                               \
			LLC_Len[0] = (UCHAR)(_DataSize / 256);                      \
			LLC_Len[1] = (UCHAR)(_DataSize % 256);                      \
			MAKE_802_3_HEADER(_p8023hdr, _pDA, _pSA, LLC_Len);          \
		}                                                               \
		else                                                            \
		{                                                               \
			MAKE_802_3_HEADER(_p8023hdr, _pDA, _pSA, pProto);           \
			_pRemovedLLCSNAP = _pData;                                  \
			_DataSize -= LENGTH_802_1_H;                                \
			_pData += LENGTH_802_1_H;                                   \
		}                                                               \
	}                                                                   \
	else                                                                \
	{                                                                   \
		LLC_Len[0] = (UCHAR)(_DataSize / 256);                          \
		LLC_Len[1] = (UCHAR)(_DataSize % 256);                          \
		MAKE_802_3_HEADER(_p8023hdr, _pDA, _pSA, LLC_Len);              \
	}                                                                   \
}

#define RECORD_LATEST_RX_DATA_RATE(_pAd, _pRxD)                                \
{                                                                               \
	if ((_pRxD)->Ofdm)                                                          \
		(_pAd)->LastRxRate = OfdmSignalToRateId[(_pRxD)->PlcpSignal & 0x0f];    \
	else if ((_pRxD)->PlcpSignal == 10)                                         \
		(_pAd)->LastRxRate = RATE_1;                                            \
	else if ((_pRxD)->PlcpSignal == 20)                                         \
		(_pAd)->LastRxRate = RATE_2;                                            \
	else if ((_pRxD)->PlcpSignal == 55)                                         \
		(_pAd)->LastRxRate = RATE_5_5;                                          \
	else                                                                        \
		(_pAd)->LastRxRate = RATE_11;                                           \
}

// NOTE: Has to copy 802.3 header to head of pData for compatibility
// with older OS eariler than W2K

// Enqueue this frame to MLME engine
// We need to enqueue the whole frame because MLME need to pass data type
// information from 802.11 header

#define REPORT_MGMT_FRAME_TO_MLME(_pAd, _pFrame, _FrameSize, _Rssi, _PlcpSignal)        \
{                                                                                       \
	MlmeEnqueueForRecv(_pAd, (UCHAR)_Rssi, _FrameSize, _pFrame, (UCHAR)_PlcpSignal);   \
}

// INFRA mode- Address 1 - AP, Address 2 - this STA, Address 3 - DA
// ADHOC mode- Address 1 - DA, Address 2 - this STA, Address 3 - BSSID
#define MAKE_802_11_HEADER(_pAd, _80211hdr, _pDA, _seq, _bDLS)                  \
{                                                                               \
	NdisZeroMemory(&_80211hdr, sizeof(HEADER_802_11));                          \
	if (_bDLS)                                                                  \
    {                                                                           \
    	COPY_MAC_ADDR(_80211hdr.Addr1, _pDA);                                   \
        COPY_MAC_ADDR(_80211hdr.Addr3, _pAd->CommonCfg.Bssid);                  \
    }                                                                           \
	else if (INFRA_ON(_pAd))                                                    \
	{                                                                           \
		COPY_MAC_ADDR(_80211hdr.Addr1, _pAd->CommonCfg.Bssid);                  \
		COPY_MAC_ADDR(_80211hdr.Addr3, _pDA);                                   \
		_80211hdr.FC.ToDs = 1;                                                  \
	}                                                                           \
	else                                                                        \
	{                                                                           \
		COPY_MAC_ADDR(_80211hdr.Addr1, _pDA);                                   \
		COPY_MAC_ADDR(_80211hdr.Addr3, _pAd->CommonCfg.Bssid);                  \
	}                                                                           \
	COPY_MAC_ADDR(_80211hdr.Addr2, _pAd->CurrentAddress);                       \
	_80211hdr.Sequence = _seq;                                                  \
	_80211hdr.FC.Type = BTYPE_DATA;                                             \
	_80211hdr.FC.PwrMgmt = (_pAd->StaCfg.Psm == PWR_SAVE);                      \
}

//Need to collect each ant's rssi concurrently
//rssi1 is report to pair2 Ant and rss2 is reprot to pair1 Ant when 4 Ant
#define COLLECT_RX_ANTENNA_AVERAGE_RSSI(_pAd, _rssi1, _rssi2)					\
{																				\
	SHORT	AvgRssi;															\
	UCHAR	UsedAnt;															\
	if (_pAd->RxAnt.EvaluatePeriod == 0)									\
	{																		\
		UsedAnt = _pAd->RxAnt.Pair1PrimaryRxAnt;							\
		AvgRssi = _pAd->RxAnt.Pair1AvgRssi[UsedAnt];						\
		if (AvgRssi < 0)													\
			AvgRssi = AvgRssi - (AvgRssi >> 3) + _rssi1;					\
		else																\
			AvgRssi = _rssi1 << 3;											\
		_pAd->RxAnt.Pair1AvgRssi[UsedAnt] = AvgRssi;						\
	}																		\
	else																	\
	{																		\
		UsedAnt = _pAd->RxAnt.Pair1SecondaryRxAnt;							\
		AvgRssi = _pAd->RxAnt.Pair1AvgRssi[UsedAnt];						\
		if ((AvgRssi < 0) && (_pAd->RxAnt.FirstPktArrivedWhenEvaluate))		\
			AvgRssi = AvgRssi - (AvgRssi >> 3) + _rssi1;					\
		else																\
		{																	\
			_pAd->RxAnt.FirstPktArrivedWhenEvaluate = TRUE;					\
			AvgRssi = _rssi1 << 3;											\
		}																	\
		_pAd->RxAnt.Pair1AvgRssi[UsedAnt] = AvgRssi;						\
		_pAd->RxAnt.RcvPktNumWhenEvaluate++;								\
	}																		\
}

#define EnqueueCmd(cmdq, cmdqelmt)		\
{										\
	if (cmdq->size == 0)				\
		cmdq->head = cmdqelmt;			\
	else								\
		cmdq->tail->next = cmdqelmt;	\
	cmdq->tail = cmdqelmt;				\
	cmdqelmt->next = NULL;				\
	cmdq->size++;						\
}

// Free Tx ring descriptor MACRO
// This can only called from complete function since it will change the IO counters
#define	FREE_TX_RING(_p, _b, _t)			\
{										\
	(_t)->InUse      = FALSE;			\
	(_t)->LastOne    = FALSE;			\
	(_t)->IRPPending = FALSE;			\
	(_t)->bWaitingBulkOut = FALSE;      \
	(_t)->BulkOutSize= 0;				\
	(_t)->bAggregatible = FALSE;		\
	(_p)->NextBulkOutIndex[_b] = (((_p)->NextBulkOutIndex[_b] + 1) % TX_RING_SIZE);	\
	NdisInterlockedDecrement(&(_p)->TxCount); \
}

#define	LOCAL_TX_RING_EMPTY(_p, _i)		(((_p)->TxContext[_i][(_p)->NextBulkOutIndex[_i]].InUse) == FALSE)

// NdisQueryBufferSafe is a MUST for NDIS 5.1 and later version.
// However, for early version, we should use it unless Ndis did not provides it.
#if _WIN32_WINNT >= 0x0501
#define NDIS_QUERY_BUFFER(_NdisBuf, _ppVA, _pBufLen)                    \
	NdisQueryBufferSafe(_NdisBuf, _ppVA, _pBufLen, NormalPagePriority)
#else
#define NDIS_QUERY_BUFFER(_NdisBuf, _ppVA, _pBufLen)                    \
	NdisQueryBuffer(_NdisBuf, _ppVA, _pBufLen)
#endif

#define MAC_ADDR_EQUAL(pAddr1,pAddr2)           RTMPEqualMemory((PVOID)(pAddr1), (PVOID)(pAddr2), MAC_ADDR_LEN)
//#define COPY_MAC_ADDR(Addr1, Addr2)             ETH_COPY_NETWORK_ADDRESS((Addr1), (Addr2))
#define SSID_EQUAL(ssid1, len1, ssid2, len2)    ((len1==len2) && (RTMPEqualMemory(ssid1, ssid2, len1)))

typedef	struct _CmdQElmt	{
	UINT				command;
	PVOID				buffer;
	ULONG				bufferlength;
	BOOLEAN				CmdFromNdis;
	BOOLEAN				SetOperation;
	BOOLEAN				InUse;// Dennis Lee
	struct _CmdQElmt	*next;
}	CmdQElmt, *PCmdQElmt;

typedef	struct	_CmdQ	{
	UINT		size;
	CmdQElmt	*head;
	CmdQElmt	*tail;
}	CmdQ, *PCmdQ;

#if defined(ME_98) && (ME_98 == 1)
//
// Can't call NdisMSendComplete (and NdisMIndicateReceivedPackets
// NdisMIndicateState) from USB completion routine.
// Use NDIS_TIMER, set it to zero timeout, and do all NDIS indications from the
// timer callback.
//
typedef struct _INDICATE_QUEUE_ELEM {
	ULONG			IndicateType;
//for NdisMEthIndicateReceive
	PUCHAR			HeaderBuffer;
	UINT			HeaderBufferSize;
	PUCHAR			LookaheadBuffer;
	UINT			LookaheadBufferSize;
	UINT			PacketSize;
//for NdisMSendComplete
	PNDIS_PACKET	Packet;
	NDIS_STATUS		Status;
} INDICATE_QUEUE_ELEM, *PINDICATE_QUEUE_ELEM;

typedef struct _INDICATE_QUEUE {
    ULONG			Num;
    ULONG			Head;
    ULONG			Tail;
    NDIS_SPIN_LOCK	Lock;
	RALINK_TIMER_STRUCT	IndicateTimer;
    INDICATE_QUEUE_ELEM	Entry[MAX_LEN_OF_INDICATE_QUEUE];
} INDICATE_QUEUE, *PINDICATE_QUEUE;
#endif

////////////////////////////////////////////////////////////////////////////
// The TX_BUFFER structure forms the transmitted USB packet to the device
////////////////////////////////////////////////////////////////////////////
typedef struct __TX_BUFFER{
	UCHAR			Aggregation[4];  //Buffer for save Aggregation size.
	TXD_STRUC		TxDesc;
	union	{
		UCHAR			WirelessPacket[MAX_AGGREGATION_SIZE];
		HEADER_802_11	NullFrame;
		PSPOLL_FRAME	PsPollPacket;
		RTS_FRAME		RTSFrame;
	}u;
} TX_BUFFER, *PTX_BUFFER;

////////////////////////////////////////////////////////////////////////////
// The RTS_BUFFER structure forms the transmitted USB packet to the device
////////////////////////////////////////////////////////////////////////////
typedef struct __RTS_BUFFER{
	TXD_STRUC      TxDesc;
	UCHAR	       RTSPacket[16];
} RTS_BUFFER, *PRTS_BUFFER;

// used to track driver-generated write irps
typedef struct _TX_CONTEXT
{
	PVOID			pAd;		//Initialized in MiniportInitialize
	PURB			pUrb;			//Initialized in MiniportInitialize
	PIRP			pIrp;			//used to cancel pending bulk out.
									//Initialized in MiniportInitialize
	PTX_BUFFER		TransferBuffer;	//Initialized in MiniportInitialize
	ULONG			BulkOutSize;
	UCHAR			BulkOutPipeId;
	BOOLEAN			InUse;
	BOOLEAN			bWaitingBulkOut;
	BOOLEAN			IRPPending;
	BOOLEAN			LastOne;
	BOOLEAN			bAggregatible;
	ULONG			DataOffset;
	UINT			TxRate;
	UCHAR			Header_802_3[LENGTH_802_3];
}	TX_CONTEXT, *PTX_CONTEXT, **PPTX_CONTEXT;

typedef enum _Pendingirp {
	NONEPENDING,
	IRP0PENDING,
	IRP1PENDING
}   PendingIRP;

typedef enum _BEACON_INDEX {
	BEACON0,
	BEACON1
}   BEACON_INDEX;

typedef enum {
	IRPLOCK_COMPLETED,
	IRPLOCK_CANCELABLE,
	IRPLOCK_CANCE_START,
	IRPLOCK_CANCE_COMPLETE,
}	IRPLOCK;

//
// Structure to keep track of receive packets and buffers to indicate
// receive data to the protocol.
//
typedef struct _RX_CONTEXT
{
	PUCHAR				TransferBuffer;
	PVOID				pAd;
	PIRP				pIrp;//used to cancel pending bulk in.
	PURB				pUrb;
	BOOLEAN				InUse;
	BOOLEAN				IRPPending;		// TODO: To be removed
#ifdef WIN_NDIS
	IRPLOCK				IrpLock;
#else
	atomic_t			IrpLock;
#endif

}	RX_CONTEXT, *PRX_CONTEXT;

//
// Register set pair for initialzation register set definition
//
typedef struct  _RTMP_REG_PAIR
{
	ULONG   Register;
	ULONG   Value;
}   RTMP_REG_PAIR, *PRTMP_REG_PAIR;

typedef struct  _BBP_REG_PAIR
{
	UCHAR   Register;
	UCHAR   Value;
}   BBP_REG_PAIR, *PBBP_REG_PAIR;

//
// Register set pair for initialzation register set definition
//
typedef struct  _RTMP_RF_REGS
{
	UCHAR   Channel;
	ULONG   R1;
	ULONG   R2;
	ULONG   R3;
	ULONG   R4;
}   RTMP_RF_REGS, *PRTMP_RF_REGS;

//
//  Statistic counter structure
//
typedef struct _COUNTER_802_3
{
	// General Stats
	ULONG       GoodTransmits;
	ULONG       GoodReceives;
	ULONG       TxErrors;
	ULONG       RxErrors;
	ULONG       RxNoBuffer;

	// Ethernet Stats
	ULONG       RcvAlignmentErrors;
	ULONG       OneCollision;
	ULONG       MoreCollisions;

}   COUNTER_802_3, *PCOUNTER_802_3;

typedef struct _COUNTER_802_11 {
	ULONG           Length;
	LARGE_INTEGER   TransmittedFragmentCount;
	LARGE_INTEGER   MulticastTransmittedFrameCount;
	LARGE_INTEGER   FailedCount;
	LARGE_INTEGER   NoRetryCount;
	LARGE_INTEGER   RetryCount;
	LARGE_INTEGER   MultipleRetryCount;
	LARGE_INTEGER   RTSSuccessCount;
	LARGE_INTEGER   RTSFailureCount;
	LARGE_INTEGER   ACKFailureCount;
	LARGE_INTEGER   FrameDuplicateCount;
	LARGE_INTEGER   ReceivedFragmentCount;
	LARGE_INTEGER   MulticastReceivedFrameCount;
	LARGE_INTEGER   FCSErrorCount;
} COUNTER_802_11, *PCOUNTER_802_11;

typedef struct _COUNTER_RALINK {
	ULONG           TransmittedByteCount;   // both successful and failure, used to calculate TX throughput
	ULONG           ReceivedByteCount;      // both CRC okay and CRC error, used to calculate RX throughput
	ULONG           BeenDisassociatedCount;
	ULONG           BadCQIAutoRecoveryCount;
	ULONG           PoorCQIRoamingCount;
	ULONG           MgmtRingFullCount;
	ULONG           RxCount;
	ULONG           RxRingErrCount;
	ULONG           KickTxCount;
	ULONG           TxRingErrCount;
	LARGE_INTEGER   RealFcsErrCount;
	ULONG           PendingNdisPacketCount;

	ULONG           OneSecOsTxCount[NUM_OF_TX_RING];
	ULONG           OneSecDmaDoneCount[NUM_OF_TX_RING];
	ULONG           OneSecTxDoneCount;
	ULONG           OneSecTxAggregationCount;
	ULONG           OneSecRxAggregationCount;

	ULONG           OneSecTxNoRetryOkCount;
	ULONG           OneSecTxRetryOkCount;
	ULONG           OneSecTxFailCount;
	ULONG           OneSecFalseCCACnt;      // CCA error count, for debug purpose, might move to global counter
	ULONG           OneSecRxOkCnt;          // RX without error
	ULONG           OneSecRxFcsErrCnt;      // CRC error
	ULONG           OneSecBeaconSentCnt;
	ULONG           OneSecAggCnt;
	ULONG           OneSecNoAggCnt;
} COUNTER_RALINK, *PCOUNTER_RALINK;

typedef struct _COUNTER_DRS {
	// to record the each TX rate's quality. 0 is best, the bigger the worse.
	USHORT          TxQuality[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR           PER[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR           TxRateUpPenalty;      // extra # of second penalty due to last unstable condition
	ULONG           CurrTxRateStableTime; // # of second in current TX rate
	BOOLEAN         fNoisyEnvironment;
	UCHAR           LastSecTxRateChangeAction; // 0: no change, 1:rate UP, 2:rate down
} COUNTER_DRS, *PCOUNTER_DRS;

typedef struct _COUNTER_QA {
	LARGE_INTEGER   CRCErrorCount;
	LARGE_INTEGER   RXOverFlowCount;
	LARGE_INTEGER   PHYErrorCount;
	LARGE_INTEGER   FalseCCACount;
	LARGE_INTEGER   U2MDataCount;
	LARGE_INTEGER   OtherDataCount;
	LARGE_INTEGER   BeaconCount;
	LARGE_INTEGER   othersCount;
}   COUNTER_QA, *PCOUNTER_QA;

//
//  Structure for pended OID query request
//
typedef struct  _RTMP_QUERY_REQUEST
{
	IN  NDIS_OID    Oid;
	IN  PVOID       pInformationBuffer;
	IN  ULONG       InformationBufferLength;
	OUT PULONG      pBytesWritten;
	OUT PULONG      pBytesNeeded;
}   RTMP_QUERY_REQUEST, *PRTMP_QUERY_REQUEST;

//
//  Structure for pended OID set request
//
typedef struct  _RTMP_SET_REQUEST
{
	IN  NDIS_OID    Oid;
	IN  PVOID       pInformationBuffer;
	IN  ULONG       InformationBufferLength;
	OUT PULONG      pBytesRead;
	OUT PULONG      pBytesNeeded;
}   RTMP_SET_REQUEST, *PRTMP_SET_REQUEST;

//
//  Arcfour Structure Added by PaulWu
//
typedef struct  _ARCFOUR
{
	UINT            X;
	UINT            Y;
	UCHAR           STATE[256];
}   ARCFOURCONTEXT, *PARCFOURCONTEXT;

// Shared key data structure
typedef struct  _WEP_KEY {
	UCHAR   KeyLen;                     // Key length for each key, 0: entry is invalid
	UCHAR   Key[MAX_LEN_OF_KEY];        // right now we implement 4 keys, 128 bits max
}   WEP_KEY, *PWEP_KEY;

typedef struct _CIPHER_KEY {
	UCHAR   BssId[6];
	UCHAR   CipherAlg;          // 0-none, 1:WEP64, 2:WEP128, 3:TKIP, 4:AES, 5:CKIP64, 6:CKIP128
	UCHAR   KeyLen;             // Key length for each key, 0: entry is invalid
	UCHAR   Key[16];            // right now we implement 4 keys, 128 bits max
	UCHAR   RxMic[8];
	UCHAR   TxMic[8];
	UCHAR   TxTsc[6];           // 48bit TSC value
	UCHAR   RxTsc[6];           // 48bit TSC value
	UCHAR   Type;               // Indicate Pairwise/Group when reporting MIC error
}   CIPHER_KEY, *PCIPHER_KEY;

typedef struct _BBP_TUNING_STRUCT {
	BOOLEAN     Enable;
	UCHAR       FalseCcaCountUpperBound;  // 100 per sec
	UCHAR       FalseCcaCountLowerBound;  // 10 per sec
	UCHAR       R17LowerBound;            // specified in E2PROM
	UCHAR       R17UpperBound;            // 0x68 according to David Tung
	UCHAR       CurrentR17Value;
} BBP_TUNING, *PBBP_TUNING;

typedef struct _SOFT_RX_ANT_DIVERSITY_STRUCT {
	UCHAR     EvaluatePeriod;		 // 0:not evalute status, 1: evaluate status, 2: switching status
	UCHAR     Pair1PrimaryRxAnt;     // 0:Ant-E1, 1:Ant-E2
	UCHAR     Pair1SecondaryRxAnt;   // 0:Ant-E1, 1:Ant-E2
	UCHAR     Pair2PrimaryRxAnt;     // 0:Ant-E3, 1:Ant-E4
	UCHAR     Pair2SecondaryRxAnt;   // 0:Ant-E3, 1:Ant-E4
	SHORT     Pair1AvgRssi[2];       // AvgRssi[0]:E1, AvgRssi[1]:E2
	SHORT     Pair2AvgRssi[2];       // AvgRssi[0]:E3, AvgRssi[1]:E4
	SHORT     Pair1LastAvgRssi;      //
	SHORT     Pair2LastAvgRssi;      //
	ULONG     RcvPktNumWhenEvaluate;
	BOOLEAN   FirstPktArrivedWhenEvaluate;
	RALINK_TIMER_STRUCT    RxAntDiversityTimer;
} SOFT_RX_ANT_DIVERSITY, *PSOFT_RX_ANT_DIVERSITY;

typedef struct _LEAP_AUTH_INFO {
	BOOLEAN         Enabled;        //Ture: Enable LEAP Authentication
	BOOLEAN         CCKM;           //Ture: Use Fast Reauthentication with CCKM
	UCHAR           Reserve[2];
	UCHAR           UserName[256];  //LEAP, User name
	ULONG           UserNameLen;
	UCHAR           Password[256];  //LEAP, User Password
	ULONG           PasswordLen;
} LEAP_AUTH_INFO, *PLEAP_AUTH_INFO;

typedef struct {
	UCHAR        Addr[MAC_ADDR_LEN];
	UCHAR        ErrorCode[2];   //00 01-Invalid authentication type
								//00 02-Authentication timeout
								//00 03-Challenge from AP failed
								//00 04-Challenge to AP failed
	BOOLEAN      Reported;
} ROGUEAP_ENTRY, *PROGUEAP_ENTRY;

typedef struct {
	UCHAR               RogueApNr;
	ROGUEAP_ENTRY       RogueApEntry[MAX_LEN_OF_BSS_TABLE];
} ROGUEAP_TABLE, *PROGUEAP_TABLE;

typedef struct {
	BOOLEAN     Enable;
	UCHAR       Delta;
	BOOLEAN     PlusSign;
} CCK_TX_POWER_CALIBRATE, *PCCK_TX_POWER_CALIBRATE;

//
// Receive Tuple Cache Format
//
typedef struct  _TUPLE_CACHE    {
	BOOLEAN         Valid;
	UCHAR           MacAddress[MAC_ADDR_LEN];
	USHORT          Sequence;
	USHORT          Frag;
}   TUPLE_CACHE, *PTUPLE_CACHE;

//
// Fragment Frame structure
//
typedef struct  _FRAGMENT_FRAME {
	UCHAR       Header802_3[LENGTH_802_3];
	UCHAR       Header_LLC[LENGTH_802_1_H];
	UCHAR       Buffer[LENGTH_802_3 + MAX_FRAME_SIZE];  // Add header to prevent NETBUEI continuous buffer isssue
	ULONG       RxSize;
	USHORT      Sequence;
	USHORT      LastFrag;
	ULONG       Flags;          // Some extra frame information. bit 0: LLC presented
}   FRAGMENT_FRAME, *PFRAGMENT_FRAME;

//
// Packet information for NdisQueryPacket
//
typedef struct  _PACKET_INFO    {
	UINT            PhysicalBufferCount;    // Physical breaks of buffer descripor chained
	UINT            BufferCount ;           // Number of Buffer descriptor chained
	UINT            TotalPacketLength ;     // Self explained
	PNDIS_BUFFER    pFirstBuffer;           // Pointer to first buffer descriptor
}   PACKET_INFO, *PPACKET_INFO;

//
// Tkip Key structure which RC4 key & MIC calculation
//
typedef struct  _TKIP_KEY_INFO  {
	UINT        nBytesInM;  // # bytes in M for MICKEY
	ULONG       IV16;
	ULONG       IV32;
	ULONG       K0;         // for MICKEY Low
	ULONG       K1;         // for MICKEY Hig
	ULONG       L;          // Current state for MICKEY
	ULONG       R;          // Current state for MICKEY
	ULONG       M;          // Message accumulator for MICKEY
	UCHAR       RC4KEY[16];
	UCHAR       MIC[8];
}   TKIP_KEY_INFO, *PTKIP_KEY_INFO;

//
// Private / Misc data, counters for driver internal use
//
typedef struct  __PRIVATE_STRUC {
	ULONG       SystemResetCnt;         // System reset counter
	ULONG       TxRingFullCnt;          // Tx ring full occurrance number
	ULONG       PhyRxErrCnt;            // PHY Rx error count, for debug purpose, might move to global counter
	// Variables for WEP encryption / decryption in rtmp_wep.c
	ULONG           FCSCRC32;
	ARCFOURCONTEXT  WEPCONTEXT;
	// Tkip stuff
	TKIP_KEY_INFO   Tx;
	TKIP_KEY_INFO   Rx;
}   PRIVATE_STRUC, *PPRIVATE_STRUC;

// structure to tune BBP R17 "RX AGC VGC init"
typedef struct _BBP_R17_TUNING {
	BOOLEAN     bEnable;
	UCHAR       R17LowerBoundG;
	UCHAR       R17LowerBoundA;
	UCHAR       R17UpperBoundG;
	UCHAR       R17UpperBoundA;
//    UCHAR       LastR17Value;
//    SHORT       R17Dec;     // R17Dec = 0x79 - RssiToDbm, for old version R17Dec = 0.
//                            // This is signed value
	USHORT      FalseCcaLowerThreshold;  // default 100
	USHORT      FalseCcaUpperThreshold;  // default 512
	UCHAR       R17Delta;                // R17 +- R17Delta whenever false CCA over UpperThreshold or lower than LowerThreshold
	UCHAR       R17CurrentValue;
	BOOLEAN		R17LowerUpperSelect; //Before LinkUp, Used LowerBound or UpperBound as R17 value.
} BBP_R17_TUNING, *PBBP_R17_TUNING;

// structure to store channel TX power
typedef struct _CHANNEL_TX_POWER {
	UCHAR      Channel;
	CHAR       Power;
}   CHANNEL_TX_POWER, *PCHANNEL_TX_POWER;

typedef enum _ABGBAND_STATE_ {
	UNKNOWN_BAND,
	BG_BAND,
	A_BAND,
} ABGBAND_STATE;

typedef struct _MLME_MEMORY_STRUCT {
	PVOID                           AllocVa;    //Pointer to the base virtual address of the allocated memory
	struct _MLME_MEMORY_STRUCT      *Next;      //Pointer to the next virtual address of the allocated memory
}   MLME_MEMORY_STRUCT, *PMLME_MEMORY_STRUCT;

typedef struct  _MLME_MEMORY_HANDLER {
	BOOLEAN                 MemRunning;         //The flag of the Mlme memory handler's status
	UINT                    MemoryCount;        //Total nonpaged system-space memory not size
	UINT                    InUseCount;         //Nonpaged system-space memory in used counts
	UINT                    UnUseCount;         //Nonpaged system-space memory available counts
	UINT                    PendingCount;       //Nonpaged system-space memory for free counts
	PMLME_MEMORY_STRUCT     pInUseHead;         //Pointer to the first nonpaed memory not used
	PMLME_MEMORY_STRUCT     pInUseTail;         //Pointer to the last nonpaged memory not used
	PMLME_MEMORY_STRUCT     pUnUseHead;         //Pointer to the first nonpaged memory in used
	PMLME_MEMORY_STRUCT     pUnUseTail;         //Pointer to the last nonpaged memory in used
	PULONG                  MemFreePending[MAX_MLME_HANDLER_MEMORY];   //an array to keep pending free-memory's pointer (32bits)
}   MLME_MEMORY_HANDLER, *PMLME_MEMORY_HANDLER;

typedef struct _MLME_STRUCT {
	// STA state machines
	STATE_MACHINE           CntlMachine;
	STATE_MACHINE           AssocMachine;
	STATE_MACHINE           AuthMachine;
	STATE_MACHINE           AuthRspMachine;
	STATE_MACHINE           SyncMachine;
	STATE_MACHINE           WpaPskMachine;
	STATE_MACHINE           LeapMachine;
	STATE_MACHINE           AironetMachine;
	STATE_MACHINE           DlsMachine;
	STATE_MACHINE_FUNC      AssocFunc[ASSOC_FUNC_SIZE];
	STATE_MACHINE_FUNC      AuthFunc[AUTH_FUNC_SIZE];
	STATE_MACHINE_FUNC      AuthRspFunc[AUTH_RSP_FUNC_SIZE];
	STATE_MACHINE_FUNC      SyncFunc[SYNC_FUNC_SIZE];
	STATE_MACHINE_FUNC      WpaPskFunc[WPA_PSK_FUNC_SIZE];
	STATE_MACHINE_FUNC      AironetFunc[AIRONET_FUNC_SIZE];
	STATE_MACHINE_FUNC      DlsFunc[DLS_FUNC_SIZE];

	// AP state machines
	STATE_MACHINE           ApCntlMachine;
	STATE_MACHINE           ApAssocMachine;
	STATE_MACHINE           ApAuthMachine;
	STATE_MACHINE           ApAuthRspMachine;
	STATE_MACHINE           ApSyncMachine;
	STATE_MACHINE           ApWpaMachine;
	STATE_MACHINE_FUNC      ApAssocFunc[AP_ASSOC_FUNC_SIZE];
	STATE_MACHINE_FUNC      ApAuthFunc[AP_AUTH_FUNC_SIZE];
	STATE_MACHINE_FUNC      ApAuthRspFunc[AP_AUTH_RSP_FUNC_SIZE];
	STATE_MACHINE_FUNC      ApSyncFunc[AP_SYNC_FUNC_SIZE];
	STATE_MACHINE_FUNC      ApWpaFunc[AP_WPA_FUNC_SIZE];

	ULONG                   ChannelQuality;  // 0..100, Channel Quality Indication for Roaming
	LARGE_INTEGER           Now64;           // latch the value of NdisGetCurrentSystemTime()

	BOOLEAN                 bRunning;
	NDIS_SPIN_LOCK          TaskLock;
	MLME_QUEUE              Queue;

	UINT                    ShiftReg;

	RALINK_TIMER_STRUCT     PeriodicTimer;

	RALINK_TIMER_STRUCT     LinkDownTimer;
	ULONG                   PeriodicRound;

	MLME_MEMORY_HANDLER     MemHandler;         //The handler of the nonpaged memory inside MLME

} MLME_STRUCT, *PMLME_STRUCT;

//
// Management ring buffer format
//
typedef	struct	_MGMT_STRUC	{
	BOOLEAN		Valid;
	PUCHAR		pBuffer;
	ULONG		Length;
}	MGMT_STRUC, *PMGMT_STRUC;

// structure for radar detection and channel switch
typedef struct _RADAR_DETECT_STRUCT {
	UCHAR		CSCount;			//Channel switch counter
	UCHAR		CSPeriod;			//Channel switch period (beacon count)
	UCHAR		RDCount;			//Radar detection counter
	UCHAR		RDMode;				//Radar Detection mode
	UCHAR		BBPR16;
	UCHAR		BBPR17;
	UCHAR		BBPR18;
	UCHAR		BBPR21;
	UCHAR		BBPR22;
	UCHAR		BBPR64;
	ULONG		InServiceMonitorCount; // unit: sec
} RADAR_DETECT_STRUCT, *PRADAR_DETECT_STRUCT;

typedef struct _RT_MESSAGE_EVENT {
	USHORT		Len;   //Length in bytes of all the following fields including this field
	UCHAR		MessageType;
	UCHAR		FunctionCode;
	USHORT		ReasonCode;
} RT_MESSAGE_EVENT, *PRT_MESSAGE_EVENT;

typedef struct _RT_MESSAGE_EVENT_LOG {
	ULONG		Capable;
	BOOLEAN		Lock;
	BOOLEAN		Reset;   //Clear message
	ULONG		MessageLogLength;
	UCHAR		MessageLog[MAX_MESSAGE_EVENT_LENGTH];
} RT_MESSAGE_EVENT_LOG, *PRT_MESSAGE_EVENT_LOG;

// configuration common to OPMODE_AP as well as OPMODE_STA
typedef struct _COMMON_CONFIG {
	UCHAR       CountryRegion;      // Enum of country region, 0:FCC, 1:IC, 2:ETSI, 3:SPAIN, 4:France, 5:MKK, 6:MKK1, 7:Israel
	UCHAR       CountryRegionForABand;	// Enum of country region for A band
	UCHAR       PhyMode;            // PHY_11A, PHY_11B, PHY_11BG_MIXED, PHY_ABG_MIXED
	USHORT      Dsifs;              // in units of usec
	ULONG       PacketFilter;       // Packet filter for receiving

	CHAR        Ssid[MAX_LEN_OF_SSID]; // NOT NULL-terminated
	UCHAR       SsidLen;               // the actual ssid length in used
	UCHAR       LastSsidLen;               // the actual ssid length in used
	CHAR        LastSsid[MAX_LEN_OF_SSID]; // NOT NULL-terminated
	UCHAR		LastBssid[MAC_ADDR_LEN];

	UCHAR       Bssid[MAC_ADDR_LEN];
	USHORT      BeaconPeriod;
	UCHAR       Channel;
	UCHAR       DefaultKeyId;

	NDIS_802_11_PRIVACY_FILTER          PrivacyFilter;  // PrivacyFilter enum for 802.1X
	NDIS_802_11_AUTHENTICATION_MODE     AuthMode;       // This should match to whatever microsoft defined
	NDIS_802_11_WEP_STATUS              WepStatus;
	NDIS_802_11_WEP_STATUS				OrigWepStatus;	// Original wep status set from OID

	// Add to support different cipher suite for WPA2/WPA mode
	NDIS_802_11_ENCRYPTION_STATUS		GroupCipher;		// Multicast cipher suite
	NDIS_802_11_ENCRYPTION_STATUS		PairCipher;			// Unicast cipher suite
	BOOLEAN								bMixCipher;			// Indicate current Pair & Group use different cipher suites
	USHORT								RsnCapability;

	NDIS_802_11_WEP_STATUS              GroupKeyWepStatus;

	UCHAR       SupRate[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR       SupRateLen;
	UCHAR       ExtRate[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR       ExtRateLen;
	UCHAR       DesireRate[MAX_LEN_OF_SUPPORTED_RATES];      // OID_802_11_DESIRED_RATES
	UCHAR       MaxDesiredRate;
	UCHAR       ExpectedACKRate[MAX_LEN_OF_SUPPORTED_RATES];

	ULONG       BasicRateBitmap;        // backup basic ratebitmap

	BOOLEAN		bAPSDCapable;
	BOOLEAN		bAPSDAC_BE;
	BOOLEAN		bAPSDAC_BK;
	BOOLEAN		bAPSDAC_VI;
	BOOLEAN		bAPSDAC_VO;
	BOOLEAN		bAPSDForcePowerSave;	// Force power save mode, should only use in APSD-STAUT
	UCHAR		MaxSPLength;

	UCHAR       TxRate;                 // RATE_1, RATE_2, RATE_5_5, RATE_11, ...
	UCHAR       MaxTxRate;              // RATE_1, RATE_2, RATE_5_5, RATE_11
	UCHAR       RtsRate;                // RATE_xxx
	UCHAR       MlmeRate;               // RATE_xxx, used to send MLME frames

	USHORT      RtsThreshold;           // in unit of BYTE
	USHORT      FragmentThreshold;      // in unit of BYTE

	UCHAR       TxPower;                // in unit of mW
	ULONG       TxPowerPercentage;      // 0~100 %
	ULONG       TxPowerDefault;         // keep for TxPowerPercentage

	USHORT      TxPreamble;             // Rt802_11PreambleLong, Rt802_11PreambleShort, Rt802_11PreambleAuto
	BOOLEAN     bUseZeroToDisableFragment;     // Microsoft use 0 as disable
	ULONG       UseBGProtection;        // 0: auto, 1: always use, 2: always not use
	BOOLEAN     bUseShortSlotTime;      // 0: disable, 1 - use short slot (9us)
	BOOLEAN     bEnableTxBurst;         // 1: enble TX PACKET BURST, 0: disable TX PACKET BURST
	BOOLEAN     bAggregationCapable;      // 1: enable TX aggregation when the peer supports it
	BOOLEAN     bIEEE80211H;			// 1: enable IEEE802.11h spec.
	UCHAR		CipherAlg;

	BOOLEAN     bWmmCapable;            // 0:disable WMM, 1:enable WMM,
                                            // also check NumberOfPipes, should be 5 for WMM supporting.
	BOOLEAN     bMultipleIRP;           // Multiple Bulk IN flag
	UCHAR       NumOfBulkInIRP;         // if bMultipleIRP == TRUE, NumOfBulkInIRP will be 4 otherwise be 1

	QOS_CAPABILITY_PARM APQosCapability;    // QOS capability of the current associated AP
	EDCA_PARM           APEdcaParm;         // EDCA parameters of the current associated AP
	QBSS_LOAD_PARM      APQbssLoad;         // QBSS load of the current associated AP
	UCHAR               AckPolicy[4];       // ACK policy of the specified AC. see ACK_xxx
	BOOLEAN             bDLSCapable;        // 0:disable DLS, 1:enable DLS

	// a bitmap of BOOLEAN flags. each bit represent an operation status of a particular
	// BOOLEAN control, either ON or OFF. These flags should always be accessed via
	// OPSTATUS_TEST_FLAG(), OPSTATUS_SET_FLAG(), OP_STATUS_CLEAR_FLAG() macros.
	// see fOP_STATUS_xxx in RTMP_DEF.C for detail bit definition
	ULONG               OpStatusFlags;

	BOOLEAN				NdisRadioStateOff; //For HCT 12.0, set this flag to TRUE instead of called MlmeRadioOff.
	ABGBAND_STATE		BandState;		// For setting BBP used on B/G or A mode.

	RADAR_DETECT_STRUCT	RadarDetect;

	RT_MESSAGE_EVENT_LOG RTMessageEvent;

	ULONG				PSPXlink;  // 0: Disable. 1: Enable

	BOOLEAN				PrivateStateChange;
	ULONG				PrivateMessage;

} COMMON_CONFIG, *PCOMMON_CONFIG;


// STA configuration and status
typedef struct _STA_ADMIN_CONFIG {
	// GROUP 1 -
	//   User configuration loaded from Registry, E2PROM or OID_xxx. These settings describe
	//   the user intended configuration, but not necessary fully equal to the final
	//   settings in ACTIVE BSS after negotiation/compromize with the BSS holder (either
	//   AP or IBSS holder).
	//   Once initialized, user configuration can only be changed via OID_xxx
	UCHAR       BssType;              // BSS_INFRA or BSS_ADHOC
	USHORT      AtimWin;          // used when starting a new IBSS

	// GROUP 2 -
	//   User configuration loaded from Registry, E2PROM or OID_xxx. These settings describe
	//   the user intended configuration, and should be always applied to the final
	//   settings in ACTIVE BSS without compromising with the BSS holder.
	//   Once initialized, user configuration can only be changed via OID_xxx
	UCHAR       RssiTrigger;
	UCHAR       RssiTriggerMode;      // RSSI_TRIGGERED_UPON_BELOW_THRESHOLD or RSSI_TRIGGERED_UPON_EXCCEED_THRESHOLD
	USHORT      DefaultListenCount;   // default listen count;
	ULONG       WindowsPowerMode;           // Power mode for AC power
	ULONG       WindowsBatteryPowerMode;    // Power mode for battery if exists
	BOOLEAN     bWindowsACCAMEnable;        // Enable CAM power mode when AC on
	BOOLEAN     bAutoReconnect;         // Set to TRUE when setting OID_802_11_SSID with no matching BSSID
#ifdef NDIS51_MINIPORT
	ULONG       WindowsPowerProfile;    // Windows power profile, for NDIS5.1 PnP
#endif
	// MIB:ieee802dot11.dot11smt(1).dot11StationConfigTable(1)
	USHORT      Psm;                  // power management mode   (PWR_ACTIVE|PWR_SAVE)
	USHORT      DisassocReason;
	UCHAR       DisassocSta[MAC_ADDR_LEN];
	USHORT      DeauthReason;
	UCHAR       DeauthSta[MAC_ADDR_LEN];
	USHORT      AuthFailReason;
	UCHAR       AuthFailSta[MAC_ADDR_LEN];

	CIPHER_KEY  PskKey;                 // WPA PSK mode PMK
	UCHAR       PTK[64];                // WPA PSK mode PTK
	BSSID_INFO	SavedPMK[PMKID_NO];
	ULONG		SavedPMKNum;			// Saved PMKID number

	// WPA 802.1x port control, WPA_802_1X_PORT_SECURED, WPA_802_1X_PORT_NOT_SECURED
	UCHAR       PortSecured;

	// For WPA countermeasures
	LARGE_INTEGER LastMicErrorTime; // record last MIC error time
	ULONG       MicErrCnt;          // Should be 0, 1, 2, then reset to zero (after disassoiciation).
	BOOLEAN     bBlockAssoc;        // Block associate attempt for 60 seconds after counter measure occurred.
	// For WPA-PSK supplicant state
	WPA_STATE   WpaState;           // Default is SS_NOTUSE and handled by microsoft 802.1x
	UCHAR       ReplayCounter[8];
	UCHAR       ANonce[32];         // ANonce for WPA-PSK from aurhenticator
	UCHAR       SNonce[32];         // SNonce for WPA-PSK

	UCHAR       LastRssi;             // last received BEACON's RSSI
	USHORT      AvgRssi;              // last 8 BEACON's average RSSI
	USHORT      AvgRssiX8;            // sum of last 8 BEACON's RSSI
	ULONG       NumOfAvgRssiSample;

	LARGE_INTEGER  LastBeaconRxTime; // OS's timestamp of the last BEACON RX time
	ULONG     	DataPacketsFromAP;     // # of data packets received from AP since we receive last Beacon from AP
	LARGE_INTEGER  Last11bBeaconRxTime; // OS's timestamp of the last 11B BEACON RX time
	LARGE_INTEGER  LastScanTime;     // Record last scan time for issue BSSID_SCAN_LIST
	ULONG       ScanCnt;            // Scan counts since most recent SSID, BSSID, SCAN OID request
	BOOLEAN     bSwRadio;           // Software controlled Radio On/Off, TRUE: On
	BOOLEAN     bHwRadio;           // Hardware controlled Radio On/Off, TRUE: On
	BOOLEAN     bRadio;             // Radio state, And of Sw & Hw radio state
	BOOLEAN     bHardwareRadio;     // Hardware controlled Radio enabled
	BOOLEAN     bShowHiddenSSID;    // Show all known SSID in SSID list get operation

	// New for WPA, windows want us to to keep association information and
	// Fixed IEs from last association response
	NDIS_802_11_ASSOCIATION_INFORMATION     AssocInfo;
	UCHAR       ReqVarIELen;                // Length of next VIE include EID & Length
	UCHAR       ReqVarIEs[MAX_VIE_LEN];
	UCHAR       ResVarIELen;                // Length of next VIE include EID & Length
	UCHAR       ResVarIEs[MAX_VIE_LEN];

	ULONG       AdhocMode;          // 0:WIFI mode (11b rates only), 1: b/g mixed, 2: 11g only, 3: 11a only, 4: 11abg mixed

	// New variables used for CCX 1.0
	BOOLEAN             bCkipCmicOn;
	UCHAR               CkipFlag;
	UCHAR               GIV[3];  //for CCX iv
	UCHAR               RxSEQ[4];
	UCHAR               TxSEQ[4];
	UCHAR               CKIPMIC[4];
	UCHAR               LeapAuthMode;
	LEAP_AUTH_INFO      LeapAuthInfo;
	UCHAR               HashPwd[16];
	UCHAR               NetworkChallenge[8];
	UCHAR               NetworkChallengeResponse[24];
	UCHAR               PeerChallenge[8];
	UCHAR               PeerChallengeResponse[24];
	UCHAR               SessionKey[16]; //Network session keys (NSK)
	RALINK_TIMER_STRUCT LeapAuthTimer;
	ROGUEAP_TABLE       RogueApTab;   //Cisco CCX1 Rogue AP Detection

	// New control flags for CCX 2.0
	CCX2_CONTROL        CCX2Control;                // Master administration state
	BOOLEAN             CCX2Enable;                 // Actual CCX state
	UCHAR               CCXScanChannel;             // Selected channel for CCX beacon request
	USHORT              CCXScanTime;                // Time out to wait for beacon and probe response
	UCHAR               CCXReqType;                 // Current processing CCX request type
	BSS_TABLE           CCXBssTab;                  // BSS Table
	UCHAR               FrameReportBuf[2048];       // Buffer for creating frame report
	USHORT              FrameReportLen;             // Current Frame report length
	ULONG               CLBusyBytes;                // Save the total bytes received durning channel load scan time
	USHORT              RPIDensity[8];              // Array for RPI density collection
	// Start address of each BSS table within FrameReportBuf
	// It's important to update the RxPower of the corresponding Bss
	USHORT              BssReportOffset[MAX_LEN_OF_BSS_TABLE];
	USHORT              BeaconToken;                // Token for beacon report
	ULONG               LastBssIndex;               // Most current reported Bss index
	RM_REQUEST_ACTION   MeasurementRequest[16];     // Saved measurement request
	UCHAR               RMReqCnt;                   // Number of measurement request saved.
	UCHAR               CurrentRMReqIdx;            // Number of measurement request saved.
	BOOLEAN             ParallelReq;                // Parallel measurement, only one request performed,
													// It must be the same channel with maximum duration
	USHORT              ParallelDuration;           // Maximum duration for parallel measurement
	UCHAR               ParallelChannel;            // Only one channel with parallel measurement
	USHORT              IAPPToken;                  // IAPP dialog token
	UCHAR               CCXQosECWMin;               // Cisco QOS ECWMin for AC 0
	UCHAR               CCXQosECWMax;               // Cisco QOS ECWMax for AC 0
	// Hack for channel load and noise histogram parameters
	UCHAR               NHFactor;                   // Parameter for Noise histogram
	UCHAR               CLFactor;                   // Parameter for channel load

	UCHAR               KRK[16];        //Key Refresh Key.
	UCHAR               BTK[32];        //Base Transient Key
	BOOLEAN             CCKMLinkUpFlag;
	ULONG               CCKMRN;    //(Re)Association request number.
	LARGE_INTEGER       CCKMBeaconAtJoinTimeStamp;  //TSF timer for Re-assocaite to the new AP
	UCHAR               AironetCellPowerLimit;      //in dBm
	UCHAR               AironetIPAddress[4];        //eg. 192.168.1.1
	BOOLEAN             CCXAdjacentAPReportFlag;    //flag for determining report Assoc Lost time
	CHAR                CCXAdjacentAPSsid[MAX_LEN_OF_SSID]; //Adjacent AP's SSID report
	UCHAR               CCXAdjacentAPSsidLen;               // the actual ssid length in used
	UCHAR               CCXAdjacentAPBssid[MAC_ADDR_LEN];         //Adjacent AP's BSSID report
	USHORT              CCXAdjacentAPChannel;
	LARGE_INTEGER       CCXAdjacentAPLinkDownTime;  //for Spec S32.

	RALINK_TIMER_STRUCT	StaQuickResponeForRateUpTimer;
	BOOLEAN				StaQuickResponeForRateUpTimerRunning;

	RT_802_11_DLS		DLSEntry[MAX_NUM_OF_DLS_ENTRY];

	BOOLEAN             bDisallowWZC;       //Control flag for WZC invalid SSID

	////////////////////////////////////////////////////////////////////////////////////////
	// This is only for WHQL test.
	//      on test item 2c_wlan_statistics, issue on [88888] FailedCount was not correctly updated
	//      FailedCount:                      155	(Query by WHQL)
	//      PacketsToSen:              	      200
	//		FailedCount:                      354	(Query by WHQL) should be 355
	//
	// Delta(base.FailedCount, current.FailedCount) < packetsToSend
	//
	// Statistic Register seems not report correct number.
	// Used this variable as trick.
	//
	BOOLEAN				WhqlTest;
	////////////////////////////////////////////////////////////////////////////////////////

} STA_ADMIN_CONFIG, *PSTA_ADMIN_CONFIG;

// This data structure keep the current active BSS/IBSS's configuration that this STA
// had agreed upon joining the network. Which means these parameters are usually decided
// by the BSS/IBSS creator instead of user configuration. Data in this data structurre
// is valid only when either ADHOC_ON(pAd) or INFRA_ON(pAd) is TRUE.
// Normally, after SCAN or failed roaming attempts, we need to recover back to
// the current active settings.
typedef struct _STA_ACTIVE_CONFIG {
	USHORT      Aid;
	USHORT      AtimWin;                // in kusec; IBSS parameter set element
	USHORT      CapabilityInfo;
	USHORT      CfpMaxDuration;
	USHORT      CfpPeriod;

	// Copy supported rate from desired AP's beacon. We are trying to match
	// AP's supported and extended rate settings.
	UCHAR       SupRate[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR       ExtRate[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR       SupRateLen;
	UCHAR       ExtRateLen;
} STA_ACTIVE_CONFIG, *PSTA_ACTIVE_CONFIG;

// ----------- start of AP --------------------------
// AUTH-RSP State Machine Aux data structure
typedef struct _AP_MLME_AUX {
	UCHAR               Addr[MAC_ADDR_LEN];
	USHORT              Alg;
	CHAR                Challenge[CIPHER_TEXT_LEN];
} AP_MLME_AUX, *PAP_MLME_AUX;

// structure to define WPA Group Key Rekey Interval
typedef struct PACKED _RT_802_11_WPA_REKEY {
	ULONG ReKeyMethod;          // mechanism for rekeying: 0:disable, 1: time-based, 2: packet-based
	ULONG ReKeyInterval;        // time-based: seconds, packet-based: kilo-packets
} RT_WPA_REKEY,*PRT_WPA_REKEY, RT_802_11_WPA_REKEY, *PRT_802_11_WPA_REKEY;

typedef struct PACKED _MAC_TABLE_ENTRY {
	BOOLEAN         Valid;
	//jan for wpa
	// record which entry revoke MIC Failure , if it leaves the BSS itself, AP won't update aMICFailTime MIB
	UCHAR           CMTimerRunning;
	UCHAR           RSNIE_Len;
	UCHAR           RSN_IE[AP_MAX_LEN_OF_RSNIE];
	UCHAR           ANonce[32];
	UCHAR           R_Counter[8];
	UCHAR           PTK[64];
	UCHAR           ReTryCounter;
	RALINK_TIMER_STRUCT                 RetryTimer;
	NDIS_802_11_AUTHENTICATION_MODE     AuthMode;   // This should match to whatever microsoft defined
	NDIS_802_11_WEP_STATUS              WepStatus;
	AP_WPA_STATE    WpaState;
	GTK_STATE       GTKState;
	USHORT          PortSecured;
	NDIS_802_11_PRIVACY_FILTER  PrivacyFilter;      // PrivacyFilter enum for 802.1X
	CIPHER_KEY         PairwiseKey;
	PVOID           pAd;

	UCHAR           Addr[MAC_ADDR_LEN];
	UCHAR           PsMode;
	SST             Sst;
	AUTH_STATE      AuthState; // for SHARED KEY authentication state machine used only
	USHORT          Aid;
	USHORT          CapabilityInfo;
	UCHAR           MaxSupportedRate;
	UCHAR           CurrTxRate;
	UCHAR           LastRssi;
	ULONG           NoDataIdleCount;
	ULONG           PsQIdleCount;
	QUEUE_HEADER    PsQueue;
	struct _MAC_TABLE_ENTRY *pNext;

	// to record the each TX rate's quality. 0 is best, the bigger the worse.
	USHORT          TxQuality[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR           PER[MAX_LEN_OF_SUPPORTED_RATES];
	USHORT          OneSecTxOkCount;
	USHORT          OneSecTxRetryOkCount;
	USHORT          OneSecTxFailCount;
	UCHAR           TxRateUpPenalty;      // extra # of second penalty due to last unstable condition
	ULONG           CurrTxRateStableTime; // # of second in current TX rate
	BOOLEAN         fNoisyEnvironment;
	UCHAR           LastSecTxRateChangeAction; // 0: no change, 1:rate UP, 2:rate down

	// a bitmap of BOOLEAN flags. each bit represent an operation status of a particular
	// BOOLEAN control, either ON or OFF. These flags should always be accessed via
	// CLIENT_STATUS_TEST_FLAG(), CLIENT_STATUS_SET_FLAG(), CLIENT_STATUS_CLEAR_FLAG() macros.
	// see fOP_STATUS_xxx in RTMP_DEF.C for detail bit definition
	ULONG           ClientStatusFlags;

	BOOLEAN         EnqueueStartForPSKTimerRunning;  // Enqueue EAPoL-Start for triggering PSK SM
	RALINK_TIMER_STRUCT EnqueueStartForPSKTimer;	// A timer which enqueue EAPoL-Start for triggering PSK SM
} MAC_TABLE_ENTRY, *PMAC_TABLE_ENTRY;

typedef struct PACKED _MAC_TABLE {
	UCHAR           Size;
	MAC_TABLE_ENTRY *Hash[HASH_TABLE_SIZE];
	MAC_TABLE_ENTRY Content[MAX_LEN_OF_MAC_TABLE];
	QUEUE_HEADER    McastPsQueue;
	ULONG           PsQIdleCount;
	BOOLEAN         fAnyStationInPsm;   // TRUE, then outgoing BCAST/MCAST frame should
										// be put into McastPsQueue until DtimCount=0
} MAC_TABLE, *PMAC_TABLE;

typedef struct PACKED _WDS_ENTRY {
	BOOLEAN         Valid;
	UCHAR           Addr[MAC_ADDR_LEN];
	ULONG           NoDataIdleCount;
	struct _WDS_ENTRY *pNext;
} WDS_ENTRY, *PWDS_ENTRY;

typedef struct PACKED _WDS_TABLE_ENTRY {
	UCHAR           Size;
	UCHAR           WdsAddr[MAC_ADDR_LEN];
	WDS_ENTRY       *Hash[HASH_TABLE_SIZE];
	WDS_ENTRY       Content[MAX_LEN_OF_MAC_TABLE];
	UCHAR           MaxSupportedRate;
	UCHAR           CurrTxRate;
	USHORT          TxQuality[MAX_LEN_OF_SUPPORTED_RATES];
	USHORT          OneSecTxOkCount;
	USHORT          OneSecTxRetryOkCount;
	USHORT          OneSecTxFailCount;
	ULONG           CurrTxRateStableTime; // # of second in current TX rate
	UCHAR           TxRateUpPenalty;      // extra # of second penalty due to last unstable condition
} WDS_TABLE_ENTRY, *PWDS_TABLE_ENTRY;

typedef struct PACKED _WDS_TABLE {
	ULONG               Size;
//  WPA_KEY             Wpa_key;
	CIPHER_KEY          Wpa_key;
	WDS_TABLE_ENTRY     MacTab[MAX_NUM_OF_WDS_LINK];
} WDS_TABLE, *PWDS_TABLE;

typedef struct PACKED _AP_ADMIN_CONFIG {
	USHORT          CapabilityInfo;

	// for wpa
	UCHAR           GMK[32];
	UCHAR           PMK[32];
	UCHAR           GNonce[32];
	UCHAR           PortSecured;  // WPA 802.1x port control, WPA_802_1X_PORT_SECURED, WPA_802_1X_PORT_NOT_SECURED
	WPA_GTK_STATE   WpaGTKState;
	RALINK_TIMER_STRUCT         CounterMeasureTimer;
	ULONG           MICErrorCounter;
	UCHAR           GKeyDoneStations; // number of entry left to update group key

	UCHAR           CMTimerRunning;
	UCHAR           BANClass3Data;
	LARGE_INTEGER   aMICFailTime;
	LARGE_INTEGER   PrevaMICFailTime;
	ULONG           MICFailureCounter;
	// for Group Rekey
	RT_WPA_REKEY    WPAREKEY;
	ULONG           REKEYCOUNTER;
	RALINK_TIMER_STRUCT     REKEYTimer;
	UCHAR           REKEYTimerRunning;

	UCHAR           LastRssi;             // last received BEACON's RSSI
	USHORT          AvgRssi;
	USHORT          AvgRssiX8;
	ULONG           NumOfAvgRssiSample;

	BOOLEAN         bAutoChannelAtBootup;  // 0: disable, 1: enable
	BOOLEAN         bIsolateInterStaTraffic;
	BOOLEAN         bHideSsid;
	BOOLEAN         bPreAuth;

	// temporary latch for Auto channel selection
	UCHAR           AutoChannel_MaxRssi;  // max RSSI during Auto Channel Selection period
	UCHAR           AutoChannel_Channel;  // channel number during Auto Channel Selection

	UCHAR           RSNIE_Len[2];
	UCHAR           RSN_IE[2][AP_MAX_LEN_OF_RSNIE];

	UCHAR           Key_Counter[32];  //jan for wpa

	UCHAR           TimIELocationInBeacon;
	UCHAR           CapabilityInfoLocationInBeacon;
	ULONG           TimBitmap;      // bit0 for broadcast, 1 for AID1, 2 for AID2, ...so on
	ULONG           TimBitmap2;     // b0 for AID32, b1 for AID33, ... and so on
    UCHAR           bTimUpdate;     /* ~~sample, bug fix for TIM update, 2006/10/04 */
	UCHAR           DtimCount;      // 0.. DtimPeriod-1
	UCHAR           DtimPeriod;     // default = 3
	UCHAR           ErpIeContent;
	BOOLEAN        bErpIEChange;
	LARGE_INTEGER           LastOLBCDetectTime;

	USHORT          AgeoutTime;     // Default 300 second
	// fo CCX 1.0
	BOOLEAN         bCkipCmicOn;
	UCHAR           CkipFlag;
	UCHAR           GIV[3];  //for CCX iv
	UCHAR           RxSEQ[4];
	UCHAR           TxSEQ[4];
	UCHAR           CKIPMIC[4];

	// EDCA parameters to be announced to its local BSS
	EDCA_PARM       BssEdcaParm;

	RALINK_TIMER_STRUCT		ApQuickResponeForRateUpTimer;
	RALINK_TIMER_STRUCT     TBTTTimer;

	BOOLEAN					ApQuickResponeForRateUpTimerRunning;
} AP_ADMIN_CONFIG, *PAP_ADMIN_CONFIG;
// ----------- end of AP ----------------------------

//
//  The miniport adapter structure
//
typedef struct _RTMP_ADAPTER
{
	// Handle given by NDIS when the Adapter registered itself.
	// Various NDIS handle function
	//
	NDIS_HANDLE             AdapterHandle;          // Adapetr Context

	// resource for software backlog queues
	QUEUE_HEADER            TxSwQueue[NUM_OF_TX_RING];  // 4 AC + 1 HCCA
	MGMT_STRUC				MgmtRing[MGMT_RING_SIZE];	// management ring size

	// SpinLocks
#if defined(ME_98) && (ME_98 == 1)
	NDIS_SPIN_LOCK          DispatchLock;               // QueryInformation spinlock
#endif

	NDIS_MEDIA_STATE        IndicateMediaState;			// Base on Indication state, default is NdisMediaStateDisConnected

	// OP mode: either AP or STA
	UCHAR                   OpMode;                     // OPMODE_STA, OPMODE_AP
	CHAR					nickn[IW_ESSID_MAX_SIZE+1]; // nickname, only used in the iwconfig i/f

	// outgoing BEACON frame buffer and corresponding TXD
	TXD_STRUC               BeaconTxD;
	CHAR                    BeaconBuf[256]; // NOTE: BeaconBuf should be 4-byte aligned

	// pre-build PS-POLL and NULL frame upon link up. for efficiency purpose.
	PSPOLL_FRAME            PsPollFrame;
	HEADER_802_11           NullFrame;

	// configuration: read from Registry & E2PROM
	BOOLEAN                 bLocalAdminMAC;             // Use user changed MAC
	UCHAR                   PermanentAddress[MAC_ADDR_LEN];    // Factory default MAC address
	UCHAR                   CurrentAddress[MAC_ADDR_LEN];      // User changed MAC address
	UCHAR                   VendorDescLen;               // the actual ssid length in used
	CHAR                    VendorDesc[MAX_LEN_OF_VENDOR_DESC]; // NOT NULL-terminated

	// ------------------------------------------------------
	// common configuration to both OPMODE_STA and OPMODE_AP
	// ------------------------------------------------------
	COMMON_CONFIG           CommonCfg;
	MLME_STRUCT             Mlme;

	// -----------------------------------------------
	// STA specific configuration & operation status
	// used only when pAd->OpMode == OPMODE_STA
	// -----------------------------------------------
	STA_ADMIN_CONFIG        StaCfg;           // user desired settings
	STA_ACTIVE_CONFIG       StaActive;         // valid only when ADHOC_ON(pAd) || INFRA_ON(pAd)
	MLME_AUX                MlmeAux;           // temporary settings used during MLME state machine
	BSS_TABLE               ScanTab;           // store the latest SCAN result

	// -----------------------------------------------
	// AP specific configuration & operation status
	// used only when pAd->OpMode == OPMODE_AP
	// -----------------------------------------------
	AP_ADMIN_CONFIG         ApCfg;             // user configuration when in AP mode
	AP_MLME_AUX             ApMlmeAux;
	MAC_TABLE               MacTab;            // client table when working as an AP
	NDIS_SPIN_LOCK          MacTabLock;
	WDS_TABLE               WdsTab;            // WDS table when working as an AP
	NDIS_SPIN_LOCK          WdsTabLock;
	RT_802_11_ACL           AccessControlList;

	// encryption/decryption KEY tables
	CIPHER_KEY              SharedKey[4][4];        // STA always use SharedKey[BSS0][0..3]
//  CIPHER_KEY              PairwiseKey[64];        // for AP only

	// 802.3 multicast support
	ULONG                   NumberOfMcastAddresses;     // Number of mcast entry exists
	UCHAR                   McastTable[MAX_MCAST_LIST_SIZE][MAC_ADDR_LEN];      // Mcast list

	// RX Tuple chahe for duplicate frame check
	TUPLE_CACHE             TupleCache[MAX_NUM_OF_TUPLE_CACHE];     // Maximum number of tuple caches, only useful in Ad-Hoc
	UCHAR                   TupleCacheLastUpdateIndex;  // 0..MAX_NUM_OF_TUPLE_CACHE-1

	// RX re-assembly buffer for fragmentation
	FRAGMENT_FRAME          FragFrame;                  // Frame storage for fragment frame

	// various Counters
	COUNTER_802_3           Counters8023;               // 802.3 counters
	COUNTER_802_11          WlanCounters;               // 802.11 MIB counters
	COUNTER_RALINK          RalinkCounters;             // Ralink propriety counters
	COUNTER_DRS             DrsCounters;                // counters for Dynamic TX Rate Switching
	PRIVATE_STRUC           PrivateInfo;                // Private information & counters

	// Counters for 802.3 & generic.
	// Add 802.11 specific counters later
	COUNTER_802_3			Counters;					// 802.3 counters

	COUNTER_QA				QACounters;				// Ralink propriety counters

	// flags, see fRTMP_ADAPTER_xxx flags
	ULONG                   Flags;                      // Represent current device status

	// current TX sequence #
	USHORT                  Sequence;

	// For MiniportTransferData
	PUCHAR                  pRxData;                    // Pointer to current RxRing offset / fragment frame offset
#if 0  // Dennis Lee
	NDIS_MINIPORT_INTERRUPT Interrupt;
	NDIS_DEVICE_POWER_STATE CurrentPowerState;          // Current device power state
	NDIS_DEVICE_POWER_STATE NextPowerState;             // Next device power state
#endif

	// Reference count
	LONG                    RefCount;           // Keep adapter refer count for checkforhang & halt
//  ULONG                   SendRefCount;       // number of packet that have not been confirmed
	ULONG                   RcvRefCount;        // number of packets that have not been returned back
#if 0  // Dennis Lee
	// Various NDIS Event
	NDIS_EVENT              ExitEvent;
	NDIS_EVENT              AllPacketsReturnedEvent;
	NDIS_HANDLE             FreeNdisPacketPoolHandle;
	NDIS_HANDLE             FreeNdisBufferPoolHandle;
#endif
	// Control disconnect / connect event generation
	ULONG                   LinkDownTime;
	ULONG                   LastRxRate;
	BOOLEAN                 bConfigChanged;         // Config Change flag for the same SSID setting

	ULONG                   ExtraInfo;              // Extra information for displaying status
	ULONG                   SystemErrorBitmap;      // b0: E2PROM version error
	ULONG                   MacIcVersion;           // MAC/BBP serial interface issue solved after ver.D

	// ---------------------------
	// System event log
	// ---------------------------
	RT_802_11_EVENT_TABLE   EventTab;

	// ---------------------------
	// E2PROM
	// ---------------------------
	ULONG                   EepromVersion;          // byte 0: version, byte 1: revision, byte 2~3: unused
	UCHAR                   EEPROMAddressNum;       // 93c46=6  93c66=8
	USHORT                  EEPROMDefaultValue[NUM_EEPROM_BBP_PARMS];

	ULONG                   FirmwareVersion;        // byte 0: Minor version, byte 1: Major version, otherwise unused.

	// ---------------------------
	// BBP Control
	// ---------------------------
	UCHAR                   BbpWriteLatch[110];     // record last BBP register value written via BBP_IO_WRITE/BBP_IO_WRITE_VY_REG_ID
	UCHAR                   BbpRssiToDbmDelta;
	BBP_R17_TUNING          BbpTuning;

	// ----------------------------
	// RFIC control
	// ----------------------------
	UCHAR                   RfIcType;       // RFIC_xxx
	ULONG                   RfFreqOffset;   // Frequency offset for channel switching
	RTMP_RF_REGS            LatchRfRegs;    // latch th latest RF programming value since RF IC doesn't support READ
//  CCK_TX_POWER_CALIBRATE  CckTxPowerCalibrate;    // 2004-05-25 add CCK TX power caliberation based on E2PROM settings

	EEPROM_ANTENNA_STRUC    Antenna;                            // Since ANtenna definition is different for a & g. We need to save it for future reference.
	EEPROM_NIC_CONFIG2_STRUC    NicConfig2;

	// This soft Rx Antenna Diversity mechanism is used only when user set
	// RX Antenna = DIVERSITY ON
	SOFT_RX_ANT_DIVERSITY   RxAnt;

	UCHAR                   RFProgSeq;
	CHANNEL_TX_POWER        TxPower[MAX_NUM_OF_CHANNELS];       // Store Tx power value for all channels.
	CHANNEL_TX_POWER        ChannelList[MAX_NUM_OF_CHANNELS];   // list all supported channels for site survey
	UCHAR                   ChannelListNum;                     // number of channel in ChannelList[]
	EEPROM_TXPOWER_DELTA_STRUC TxPowerDeltaConfig;				// Compensate the Tx power BBP94 with this configurate value
	UCHAR					Bbp94;
	BOOLEAN					BbpForCCK;

//  UCHAR       ChannelTssiRef[MAX_NUM_OF_CHANNELS];            // Store Tssi Reference value for all channels.
//  UCHAR       ChannelTssiDelta;                               // Store Tx TSSI delta increment / decrement value

	BOOLEAN     bAutoTxAgcA;                // Enable driver auto Tx Agc control
	UCHAR	    TssiRefA;					// Store Tssi reference value as 25 tempature.
	UCHAR	    TssiPlusBoundaryA[5];		// Tssi boundary for increase Tx power to compensate.
	UCHAR	    TssiMinusBoundaryA[5];		// Tssi boundary for decrease Tx power to compensate.
	UCHAR	    TxAgcStepA;					// Store Tx TSSI delta increment / decrement value
	CHAR		TxAgcCompensateA;			// Store the compensation (TxAgcStep * (idx-1))

	BOOLEAN     bAutoTxAgcG;                // Enable driver auto Tx Agc control
	UCHAR	    TssiRefG;					// Store Tssi reference value as 25 tempature.
	UCHAR	    TssiPlusBoundaryG[5];		// Tssi boundary for increase Tx power to compensate.
	UCHAR	    TssiMinusBoundaryG[5];		// Tssi boundary for decrease Tx power to compensate.
	UCHAR	    TxAgcStepG;					// Store Tx TSSI delta increment / decrement value
	CHAR		TxAgcCompensateG;			// Store the compensation (TxAgcStep * (idx-1))

	CHAR		BGRssiOffset1;				// Store B/G RSSI#1 Offset value on EEPROM 0x9Ah
	CHAR		BGRssiOffset2;				// Store B/G RSSI#2 Offset value
	CHAR		ARssiOffset1;				// Store A RSSI#1 Offset value on EEPROM 0x9Ch
	CHAR		ARssiOffset2;				// Store A RSSI#2 Offset value

	// ----------------------------
	// LED control
	// ----------------------------
	MCU_LEDCS_STRUC		LedCntl;
	USHORT				LedIndicatorStrength;

	// ----------------------------
	// DEBUG paramerts
	// ----------------------------
	// ULONG                   DebugSetting[4];

	NDIS_MEDIA_STATE        MediaState;

	/////////////////////
	// USB
	/////////////////////
#ifdef WIN_NDIS
	PUSB_DEVICE_DESCRIPTOR              pUsbDeviceDescriptor;
	USBD_CONFIGURATION_HANDLE           UsbConfigurationHandle;
	ULONG                               NumberOfPipes;
	USBD_PIPE_HANDLE                    BulkInPipeHandle;
	USBD_PIPE_HANDLE                    BulkOutPipeHandle[4];	// There are 4 bulk for each AC categories
#endif
	USHORT                              BulkOutMaxPacketSize;
	USHORT                              BulkInMaxPacketSize;
	// Various NDIS Event
#ifdef WIN_NDIS
	NDIS_EVENT                          RemoveEvent;

	//////////////////////////////////////////
	/// USB
	//////////////////////////////////////////
	PDEVICE_OBJECT          pNextDeviceObject;
	BOOLEAN					TerminateThreads;
	HANDLE					hControlThread;
	KEVENT					ControlEvent;
	HANDLE					hMLMEThread;
	KEVENT					MLMEEvent;
#endif

	CmdQ					CmdQ;
	CmdQElmt				CmdQElements[COMMAND_QUEUE_SIZE];

#if defined(ME_98) && (ME_98 == 1)
	BOOLEAN					IndicateRunning;
	NDIS_SPIN_LOCK			IndicateTaskLock;

	INDICATE_QUEUE			IndicateQueue;
#endif


	BOOLEAN					DeQueueRunning[4];			// for ensuring RTUSBDeQueuePacket get call once
	BOOLEAN					DeMGMTQueueRunning;		// for ensuring RTUSBDeQueuePacket get call once
	// SpinLocks
	NDIS_SPIN_LOCK			SendTxWaitQueueLock[4];		// SendTxWaitQueue spinlock

	NDIS_SPIN_LOCK			DataQLock[4];
	NDIS_SPIN_LOCK			DeQueueLock[4];

	NDIS_SPIN_LOCK			MLMEWaitQueueLock;		// SendTxWaitQueue spinlock
	NDIS_SPIN_LOCK			DeMGMTQueueLock;				// for ensuring RTUSBDeQueuePacket get call once
	NDIS_SPIN_LOCK			CmdQLock;		// SendTxWaitQueue spinlock
	NDIS_SPIN_LOCK			BulkOutLock[4];		// SendTxWaitQueue spinlock for 4 ACs

	NDIS_SPIN_LOCK			ControlLock;		// SendTxWaitQueue spinlock
	NDIS_SPIN_LOCK			MLMEQLock;		// SendTxWaitQueue spinlock
	NDIS_SPIN_LOCK			GenericLock;		// SendTxWaitQueue spinlock

	/////////////////////
	// Transmit Path
	/////////////////////
	TX_CONTEXT							MLMEContext[PRIO_RING_SIZE];
	TX_CONTEXT							BeaconContext[BEACON_RING_SIZE];
	TX_CONTEXT							NullContext;
	TX_CONTEXT							PsPollContext;
	TX_CONTEXT							RTSContext;
	TX_CONTEXT							SpecialDataContext;
	PUCHAR								TxBuffer;
	TX_BUFFER                           TxMgmtBuf;
	PURB                                pTxMgmtUrb;
	PIRP                                pTxMgmtIrp;
	QUEUE_HEADER            SendTxWaitQueue[4];


	UINT32					TxRingTotalNumber[4] ;
	UCHAR					NextTxIndex[4];				// Next TxD write pointer

	UCHAR					NextMLMEIndex;				// Next PrioD write pointer
	UCHAR					PushMgmtIndex;				// Next SW management ring index
	UCHAR					PopMgmtIndex;				// Next SW management ring index
	atomic_t				MgmtQueueSize;				// Number of Mgmt request stored in MgmtRing
	UCHAR					NextRxBulkInIndex;

	// 4 sets of Bulk Out index and pending flag
	UCHAR					NextBulkOutIndex[4];
	BOOLEAN					BulkOutPending[4];

	BOOLEAN					ControlPending;
	LONG					PrioRingTxCnt;
	UCHAR					PrioRingFirstIndex;

	atomic_t						TxCount;		// Number of Bulkout waiting to be send.
	LONG                                PendingTx;

	// Data related context and AC specified, 4 AC supported
	TX_CONTEXT					TxContext[4][TX_RING_SIZE];
	LONG						NumPacketsQueued[4];
	PURB						pTxUrb[4];
	PIRP						pTxIrp[4];
	PNDIS_PACKET				TxQHead[4];
	PNDIS_PACKET				TxQTail[4];


	/////////////////////
	// Receive Path
	/////////////////////
	RX_CONTEXT							RxContext[RX_RING_SIZE + 1];  // 1 for redundant multiple IRP bulk in.
	PURB                                pRxUrb;
	PIRP                                pRxIrp;
	PUCHAR								RxBuffer;
	atomic_t	                        PendingRx;

	/////////////////////
	//  Control Flags
	/////////////////////
	LONG                                PendingIoCount;
	// Flags for bulk out data priority
	ULONG					BulkFlags;


	NDIS_SPIN_LOCK          MemLock;
	ULONG					BulkOutDataOneSecCount;
	ULONG					BulkInDataOneSecCount;
	ULONG					BulkLastOneSecCount; // BulkOutDataOneSecCount + BulkInDataOneSecCount
	PVOID					OS_Cookie;
	PNET_DEV				net_dev;
	struct usb_device				*pUsb_Dev;

	struct semaphore	usbdev_semaphore;		/* protect	usb */
	// Thread
	struct semaphore	mlme_semaphore;			/* to sleep thread on	*/
	struct semaphore	RTUSBCmd_semaphore;		/* to sleep thread on	*/
	struct completion	notify;
	struct tasklet_struct			rx_bh;
	struct usb_config_descriptor	*config;

	pid_t					MLMEThr_pid;// Dennis Lee should move to os_cookie
	pid_t					RTUSBCmdThr_pid;
	wait_queue_head_t	*wait;

	#if WIRELESS_EXT >= 12
	struct iw_statistics iw_stats;
#endif
	struct net_device_stats stats;

} RTMP_ADAPTER, *PRTMP_ADAPTER;

#ifdef WIN_NDIS
//
//  Registery definition
//
typedef struct  _RTMP_REG_ENTRY
{
	NDIS_STRING     RegName;            // variable name text
	BOOLEAN         bRequired;          // 1 -> required, 0 -> optional
	UCHAR           Type;               // Field Type
	UINT            FieldOffset;        // offset to MP_ADAPTER field
	UINT            FieldSize;          // size (in bytes) of the field
	UINT            Default;            // default value to use
	UINT            Min;                // minimum value allowed
	UINT            Max;                // maximum value allowed
}   RTMP_REG_ENTRY, *PRTMP_REG_ENTRY;
#endif
//
// SHA context
//
typedef struct _SHA_CTX
{
	ULONG       H[5];
	ULONG       W[80];
	INT         lenW;
	ULONG       sizeHi, sizeLo;
}   SHA_CTX;


//
// Cisco IAPP format
//
typedef struct  _CISCO_IAPP_CONTENT_
{
	USHORT     Length;        //IAPP Length
	UCHAR      MessageType;      //IAPP type
	UCHAR      FunctionCode;     //IAPP function type
	UCHAR      DestinaionMAC[MAC_ADDR_LEN];
	UCHAR      SourceMAC[MAC_ADDR_LEN];
	USHORT     Tag;           //Tag(element IE) - Adjacent AP report
	USHORT     TagLength;     //Length of element not including 4 byte header
	UCHAR      OUI[4];           //0x00, 0x40, 0x96, 0x00
	UCHAR      PreviousAP[MAC_ADDR_LEN];       //MAC Address of access point
	USHORT     Channel;
	USHORT     SsidLen;
	UCHAR      Ssid[MAX_LEN_OF_SSID];
	USHORT     Seconds;          //Seconds that the client has been disassociated.
} CISCO_IAPP_CONTENT, *PCISCO_IAPP_CONTENT;

////////////////////////////////////////////////////////////////////////////
//
//  inline FUNCTIONS
//
//   IncrementIoCount and DecrementIoCount
//
//  DESCRIPTION
//
//   We keep a pending IO count. This count is initialized to one.
//   Subsequently, the count is incremented for each new IRP received or
//   created and is decremented when each IRP is completed.
//   Transition to 'one' therefore indicates no IO is pending and signals
//   Adapter->RemoveEvent. Transition to 'zero' signals an event
//   (Adapter->RemoveEvent) to enable device removal.
//
//  INPUT
//
//    Adapter                       Ptr to the adapter object
//
//  OUTPUT
//
//    -
//
////////////////////////////////////////////////////////////////////////////

// Macro for rx indication
VOID REPORT_ETHERNET_FRAME_TO_LLC(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			p8023hdr,
	IN	PUCHAR			pData,
	IN	ULONG			DataSize,
	IN  PNET_DEV		net_dev);

NDIS_STATUS os_alloc_mem(
	IN	PRTMP_ADAPTER pAd,
	OUT	PUCHAR *mem,
	IN	ULONG  size);

	/* timeout -- ms */
VOID RTMP_SetPeriodicTimer(
	IN	NDIS_MINIPORT_TIMER *pTimer,
	IN	unsigned long timeout);

VOID RTMP_OS_Init_Timer(
	IN	PRTMP_ADAPTER pAd,
	IN	NDIS_MINIPORT_TIMER *pTimer,
	IN	TIMER_FUNCTION function,
	IN	PVOID data);

VOID RTMP_OS_Add_Timer(
	IN	NDIS_MINIPORT_TIMER	*pTimer,
	IN	unsigned long timeout);

VOID RTMP_OS_Mod_Timer(
	IN	NDIS_MINIPORT_TIMER	*pTimer,
	IN	unsigned long timeout);


VOID RTMP_OS_Del_Timer(
	IN	NDIS_MINIPORT_TIMER	*pTimer,
	OUT	BOOLEAN				 *pCancelled);


VOID RTMP_OS_Release_Packet(
	IN	PRTMP_ADAPTER pAd,
	IN	PQUEUE_ENTRY  pEntry);


#ifdef WIN_NDIS
// Unify all delay routine by using NdisStallExecution
__inline    VOID    RTMPusecDelay(
    IN      ULONG   usec)
{
	ULONG   i;

	for (i = 0; i < (usec / 50); i++)
		NdisStallExecution(50);

	if (usec % 50)
		NdisStallExecution(usec % 50);
}

__inline VOID IncrementIoCount(PRTMP_ADAPTER pAd)
{
	InterlockedIncrement(&pAd->PendingIoCount);
}

////////////////////////////////////////////////////////////////////////////
__inline VOID DecrementIoCount(IN PRTMP_ADAPTER pAd)
{
	InterlockedDecrement(&pAd->PendingIoCount);

	if ((pAd->PendingIoCount <= 0) &&
		(pAd->hControlThread == NULL))
	{
		NdisSetEvent(&pAd->RemoveEvent);
	}
}
#endif

#define DEVICE_VENDOR_REQUEST_OUT       0x40
#define DEVICE_VENDOR_REQUEST_IN        0xc0
#define INTERFACE_VENDOR_REQUEST_OUT    0x41
#define INTERFACE_VENDOR_REQUEST_IN     0xc1

#ifdef WIN_NDIS
//
//  Miniport routines in rtmp_main.c
//
NDIS_STATUS DriverEntry(
	IN  PDRIVER_OBJECT      pDriverObject,
	IN  PUNICODE_STRING     pRegistryPath
	);

BOOLEAN RTMPCheckForHang(
	IN  NDIS_HANDLE MiniportAdapterContext
	);

VOID RTMPHalt(
	IN  NDIS_HANDLE MiniportAdapterContext
	);

NDIS_STATUS RTMPInitialize(
	OUT PNDIS_STATUS    pOpenErrorStatus,
	OUT PUINT           pSelectedMediumIndex,
	IN  PNDIS_MEDIUM    MediumArray,
	IN  UINT            MediumArraySize,
	IN  NDIS_HANDLE     MiniportAdapterHandle,
	IN  NDIS_HANDLE     WrapperConfigurationContext
	);
#endif

#if defined(ME_98) && (ME_98 == 1)
NTSTATUS RTMPDispatch(
	IN PDEVICE_OBJECT   DeviceObject,
	IN PIRP             Irp
	);
#endif

NDIS_STATUS RTMPQueryInformation(
	IN  NDIS_HANDLE MiniportAdapterContext,
	IN  NDIS_OID    Oid,
	IN  PVOID       pInformationBuffer,
	IN  ULONG       InformationBufferLength,
	OUT PULONG      pBytesWritten,
	OUT PULONG      pBytesNeeded
	);

NDIS_STATUS STAQueryInformation(
	IN  NDIS_HANDLE MiniportAdapterContext,
	IN  NDIS_OID    Oid,
	IN  PVOID       pInformationBuffer,
	IN  ULONG       InformationBufferLength,
	OUT PULONG      pBytesWritten,
	OUT PULONG      pBytesNeeded
	);

#ifdef WIN_NDIS
NDIS_STATUS RTMPReset(
	OUT PBOOLEAN    pAddressingReset,
	IN  NDIS_HANDLE MiniportAdapterContext
	);
#endif

NDIS_STATUS RTMPSetInformation(
	IN  NDIS_HANDLE MiniportAdapterContext,
	IN  NDIS_OID    Oid,
	IN  PVOID       pInformationBuffer,
	IN  ULONG       InformationBufferLength,
	OUT PULONG      pBytesRead,
	OUT PULONG      pBytesNeeded
	);

NDIS_STATUS STASetInformation(
	IN  NDIS_HANDLE MiniportAdapterContext,
	IN  NDIS_OID    Oid,
	IN  PVOID       pInformationBuffer,
	IN  ULONG       InformationBufferLength,
	OUT PULONG      pBytesRead,
	OUT PULONG      pBytesNeeded
	);

#ifdef WIN_NDIS
NDIS_STATUS RTMPTransferData(
	OUT PNDIS_PACKET    pPacket,
	OUT PUINT           pBytesTransferred,
	IN  NDIS_HANDLE     MiniportAdapterContext,
	IN  NDIS_HANDLE     MiniportReceiveContext,
	IN  UINT            ByteOffset,
	IN  UINT            BytesToTransfer
	);
#endif

#ifdef  NDIS51_MINIPORT

VOID RTMPPnPEventNotify(
	IN  NDIS_HANDLE             MiniportAdapterContext,
	IN  NDIS_DEVICE_PNP_EVENT   PnPEvent,
	IN  PVOID                   pInformationBuffer,
	IN  ULONG                   InformationBufferLength
	);

VOID RTMPShutdown(
	IN  NDIS_HANDLE     MiniportAdapterContext);

#endif  // NDIS51_MINIPORT

//
//  Private routines in rtmp_init.c
//
NDIS_STATUS RTMPAllocAdapterBlock(
	IN PVOID	handle,
	OUT PRTMP_ADAPTER   *ppAd
	);

NDIS_STATUS	NICInitTransmit(
	IN	PRTMP_ADAPTER	pAd
	);

NDIS_STATUS NICInitRecv(
	IN	PRTMP_ADAPTER	pAd
    );

NDIS_STATUS RTMPInitAdapterBlock(
	IN  PRTMP_ADAPTER   pAd
	);

VOID    RTMPFreeAdapter(
	IN  PRTMP_ADAPTER   pAd
	);

NDIS_STATUS NICReadRegParameters(
	IN  PRTMP_ADAPTER       pAd,
	IN  NDIS_HANDLE         WrapperConfigurationContext
	);

NDIS_STATUS	RTUSBWriteHWMACAddress(
	IN	PRTMP_ADAPTER		pAdapter);

VOID NICReadEEPROMParameters(
	IN  PRTMP_ADAPTER       pAd);

VOID NICInitAsicFromEEPROM(
	IN  PRTMP_ADAPTER       pAd);

VOID NICWaitMACReady(
	IN	PRTMP_ADAPTER	pAd);

NDIS_STATUS NICInitializeAsic(
	IN  PRTMP_ADAPTER   pAd);

VOID NICIssueReset(
	IN  PRTMP_ADAPTER   pAd);

VOID UserCfgInit(
	IN  PRTMP_ADAPTER   pAd);

VOID NICResetFromError(
	IN  PRTMP_ADAPTER   pAd);

NDIS_STATUS NICLoadFirmware(
	IN  PRTMP_ADAPTER   pAd);

BOOLEAN NICCheckForHang(
	IN  PRTMP_ADAPTER   pAd);

VOID NICUpdateRawCounters(
	IN  PRTMP_ADAPTER   pAd);

#ifdef WIN_NDIS
ULONG RTMPEqualMemory(
	IN  PVOID   pSrc1,
	IN  PVOID   pSrc2,
	IN  ULONG   Length);

VOID RTMPZeroMemory(
	IN  PVOID   pSrc,
	IN  ULONG   Length);

#endif
VOID RTMPMoveMemory(
	OUT PVOID   pDest,
	IN  PVOID   pSrc,
	IN  ULONG   Length);

VOID RTMPReadParametersFromFile(
	IN	PRTMP_ADAPTER pAd);

ULONG RTMPCompareMemory(
	IN  PVOID   pSrc1,
	IN  PVOID   pSrc2,
	IN  ULONG   Length);

void AtoH(CHAR * src, UCHAR * dest, int destlen);
UCHAR BtoH(CHAR ch);

VOID RTMPPatchMacBbpBug(
	IN  PRTMP_ADAPTER   pAd);

VOID	RTMPInitTimer(
	IN	PRTMP_ADAPTER			pAd,
	IN	PRALINK_TIMER_STRUCT	pTimer,
	IN	PVOID					pTimerFunc,
	IN	PVOID					pData,
	IN  BOOLEAN					Repeat);

VOID	RTMPSetTimer(
	IN	PRALINK_TIMER_STRUCT	pTimer,
	IN	ULONG					Value);

VOID	RTMPModTimer(
	IN	PRALINK_TIMER_STRUCT	pTimer,
	IN	ULONG					Value);

VOID RTMPCancelTimer(
	IN  PRALINK_TIMER_STRUCT    pTimer,
	OUT BOOLEAN                 *pCancelled);

VOID RTMPSetLED(
	IN PRTMP_ADAPTER 	pAd,
	IN UCHAR			Status);

VOID RTMPSetSignalLED(
	IN PRTMP_ADAPTER 	pAd,
	IN NDIS_802_11_RSSI Dbm);

VOID RTMPCckBbpTuning(
	IN	PRTMP_ADAPTER	pAd,
	IN	UINT			TxRate);

VOID RTMPSetMessageEvent(
	IN PRTMP_ADAPTER	pAd,
	IN ULONG			EventId,
	IN UCHAR			MessageType,
	IN UCHAR			FunctionCode,
	IN USHORT			ReasonCode,
	IN PUCHAR			pMacAddress);

NDIS_STATUS RTMPFreeTXDRequest(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           RingType,
	IN  UCHAR           NumberRequired,
	IN 	PUCHAR          FreeNumberIs);

NDIS_STATUS MlmeHardTransmit(
	IN  PRTMP_ADAPTER   pAd,
	IN  PNDIS_PACKET    pPacket);

USHORT  RTMPCalcDuration(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Rate,
	IN  ULONG           Size);

BOOLEAN RTMPSearchTupleCache(
	IN  PRTMP_ADAPTER   pAd,
	IN  PHEADER_802_11  pHeader);

VOID    RTMPUpdateTupleCache(
	IN  PRTMP_ADAPTER   pAd,
	IN  PHEADER_802_11  pHeader);

VOID MiniportMMRequest(
	IN	PRTMP_ADAPTER	pAd,
	IN	PVOID			pBuffer,
	IN	ULONG			Length);

VOID    RTMPSendRTSCTSFrame(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pDA,
	IN  ULONG           NextMpduSize,
	IN  UCHAR           TxRate,
	IN  UCHAR           RTSRate,
	IN  USHORT          AckDuration,
	IN  UCHAR           QueIdx,
	IN  UCHAR           FrameGap,
	IN  UCHAR           Type);

NDIS_STATUS RTMPApplyPacketFilter(
	IN  PRTMP_ADAPTER   pAd,
	IN  PRXD_STRUC      pRxD,
	IN  PHEADER_802_11  pHeader);

PQUEUE_HEADER   RTMPCheckTxSwQueue(
	IN  PRTMP_ADAPTER   pAd,
	OUT ULONG           *Number,
	OUT UCHAR           *QueIdx);

VOID    RTMPReportMicError(
	IN  PRTMP_ADAPTER   pAd,
	IN  PCIPHER_KEY     pWpaKey);

NDIS_STATUS RTMPCloneNdisPacket(
	IN  PRTMP_ADAPTER   pAd,
	IN  PNDIS_PACKET    pInPacket,
	OUT PNDIS_PACKET   *ppOutPacket);

NDIS_STATUS RTMPAllocateNdisPacket(
	IN  PRTMP_ADAPTER   pAd,
	IN  PNDIS_PACKET    *pPacket,
	IN  PUCHAR          pHeader,
	IN  UINT            HeaderLen,
	IN  PUCHAR          pData,
	IN  UINT            DataLen);

VOID RTMPFreeNdisPacket(
	IN  PRTMP_ADAPTER   pAd,
	IN  PNDIS_PACKET    pPacket);

VOID RTMP_SendComplete(
    IN NDIS_HANDLE  MiniportAdapterHandle,
    IN PNDIS_PACKET  Packet,
    IN NDIS_STATUS  Status
    );

VOID RTMPFreeTXDUponTxDmaDone(
	IN PRTMP_ADAPTER    pAd,
	IN UCHAR            QueIdx,
	IN UINT             RingSize);

BOOLEAN RTMPCheckDHCPFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket);

#if defined(ME_98) && (ME_98 == 1)
NDIS_STATUS IndicateQueueInit(
	IN PRTMP_ADAPTER pAd);

BOOLEAN IndicateEnqueue(
	IN	PRTMP_ADAPTER pAd,
	IN	ULONG	IndicateType,
	IN	PUCHAR	HeaderBuffer,
	IN	UINT	HeaderBufferSize,
	IN	PUCHAR	LookaheadBuffer,
	IN	UINT	LookaheadBufferSize,
	IN	UINT	PacketSize,
	IN	PNDIS_PACKET Packet,
	IN	NDIS_STATUS	Status);

BOOLEAN IndicateQueueEmpty(
    IN INDICATE_QUEUE *Queue);

BOOLEAN IndicateQueueFull(
    IN INDICATE_QUEUE *Queue);

BOOLEAN IndicateDequeue(
    IN INDICATE_QUEUE *Queue,
    OUT INDICATE_QUEUE_ELEM **Elem);

VOID IndicateQueueDestroy(
	IN PRTMP_ADAPTER pAd);

VOID RTUSBNdicateCallBack(
    IN PVOID SystemSpecific1,
    IN PVOID FunctionContext,
    IN PVOID SystemSpecific2,
    IN PVOID SystemSpecific3);

VOID RTUSBIndicateDone(
	IN PRTMP_ADAPTER pAd);
#endif

//
// Private routines in rtmp_wep.c
//
VOID    RTMPInitWepEngine(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pKey,
	IN  UCHAR           KeyId,
	IN  UCHAR           KeyLen,
	IN  PUCHAR          pDest);

VOID    RTMPEncryptData(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pSrc,
	IN  PUCHAR          pDest,
	IN  UINT            Len);

BOOLEAN	RTMPDecryptData(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			pSrc,
	IN	PUCHAR			pKey,
	IN	UINT			Len);

VOID    RTMPSetICV(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pDest);

VOID    ARCFOUR_INIT(
	IN  PARCFOURCONTEXT Ctx,
	IN  PUCHAR          pKey,
	IN  UINT            KeyLen);

UCHAR   ARCFOUR_BYTE(
	IN  PARCFOURCONTEXT     Ctx);

VOID    ARCFOUR_DECRYPT(
	IN  PARCFOURCONTEXT Ctx,
	IN  PUCHAR          pDest,
	IN  PUCHAR          pSrc,
	IN  UINT            Len);

VOID    ARCFOUR_ENCRYPT(
	IN  PARCFOURCONTEXT Ctx,
	IN  PUCHAR          pDest,
	IN  PUCHAR          pSrc,
	IN  UINT            Len);

VOID    WPAARCFOUR_ENCRYPT(
	IN  PARCFOURCONTEXT Ctx,
	IN  PUCHAR          pDest,
	IN  PUCHAR          pSrc,
	IN  UINT            Len);

ULONG   RTMP_CALC_FCS32(
	IN  ULONG   Fcs,
	IN  PUCHAR  Cp,
	IN  INT     Len);

//
// MLME routines
//

// Asic/RF/BBP related functions

VOID AsicAdjustTxPower(
	IN PRTMP_ADAPTER pAd);

VOID    AsicSwitchChannel(
	IN  PRTMP_ADAPTER   pAd,
	IN UCHAR Channel);

VOID    AsicLockChannel(
	IN PRTMP_ADAPTER pAd,
	IN UCHAR Channel) ;

VOID    AsicAntennaSelect(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Channel);

VOID	AsicAntennaSetting(
	IN	PRTMP_ADAPTER	pAd,
	IN	ABGBAND_STATE	BandState);

VOID    AsicSleepThenAutoWakeup(
	IN  PRTMP_ADAPTER   pAd,
	IN  USHORT TbttNumToNextWakeUp);

VOID    AsicForceSleep(
	IN PRTMP_ADAPTER pAd);

VOID    AsicForceWakeup(
	IN PRTMP_ADAPTER pAd);

VOID    AsicSetBssid(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR pBssid);

VOID    AsicDisableSync(
	IN  PRTMP_ADAPTER   pAd);

VOID    AsicEnableBssSync(
	IN  PRTMP_ADAPTER   pAd);

VOID    AsicEnableIbssSync(
	IN  PRTMP_ADAPTER   pAd);

VOID AsicSetEdcaParm(
	IN PRTMP_ADAPTER pAd,
	IN PEDCA_PARM    pEdcaParm);

VOID AsicSetSlotTime(
	IN PRTMP_ADAPTER pAd,
	IN BOOLEAN bUseShortSlotTime);

VOID AsicBbpTuning(
	IN PRTMP_ADAPTER pAd);
VOID AsicResetBbpTuning(
	IN PRTMP_ADAPTER pAd);

VOID AsicAddSharedKeyEntry(
	IN PRTMP_ADAPTER pAd,
	IN UCHAR         BssIndex,
	IN UCHAR         KeyIdx,
	IN UCHAR         CipherAlg,
	IN PUCHAR        pKey,
	IN ULONG         KeyLen,
	IN PUCHAR        pTxMic,
	IN PUCHAR        pRxMic);

VOID AsicRemoveSharedKeyEntry(
	IN PRTMP_ADAPTER pAd,
	IN UCHAR         BssIndex,
	IN UCHAR         KeyIdx);

VOID AsicAddPairwiseKeyEntry(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR        pAddr,
	IN UCHAR         KeyIdx,
	IN UCHAR         CipherAlg,
	IN PUCHAR        pKey,
	IN PUCHAR        pTxMic,
	IN PUCHAR        pRxMic);

VOID AsicRemovePairwiseKeyEntry(
	IN PRTMP_ADAPTER  pAd,
	IN UCHAR         KeyIdx);

VOID    MacAddrRandomBssid(
	IN  PRTMP_ADAPTER   pAd,
	OUT PUCHAR pAddr);

VOID    MgtMacHeaderInit(
	IN  PRTMP_ADAPTER     pAd,
	IN OUT PHEADER_802_11 pHdr80211,
	IN UCHAR SubType,
	IN UCHAR ToDs,
	IN PUCHAR pDA,
	IN PUCHAR pBssid);

VOID MlmeRadioOff(
	IN PRTMP_ADAPTER pAd);

VOID MlmeRadioOn(
	IN PRTMP_ADAPTER pAd);

VOID  BssTableInit(
	IN BSS_TABLE *Tab);

ULONG BssTableSearch(
	IN BSS_TABLE *Tab,
	IN PUCHAR pBssid,
	IN UCHAR Channel);

ULONG BssSsidTableSearch(
	IN BSS_TABLE *Tab,
	IN PUCHAR    pBssid,
	IN PUCHAR    pSsid,
	IN UCHAR     SsidLen,
	IN UCHAR     Channel);

ULONG BssTableSearchWithSSID(
	IN BSS_TABLE *Tab,
	IN PUCHAR    Bssid,
	IN PUCHAR    pSsid,
	IN UCHAR     SsidLen,
	IN UCHAR     Channel);

VOID BssTableDeleteEntry(
	IN OUT  PBSS_TABLE pTab,
	IN      PUCHAR pBssid,
	IN      UCHAR Channel);

VOID  BssEntrySet(
	IN  PRTMP_ADAPTER   pAd,
	OUT PBSS_ENTRY pBss,
	IN PUCHAR pBssid,
	IN CHAR Ssid[],
	IN UCHAR SsidLen,
	IN UCHAR BssType,
	IN USHORT BeaconPeriod,
	IN PCF_PARM CfParm,
	IN USHORT AtimWin,
	IN USHORT CapabilityInfo,
	IN UCHAR SupRate[],
	IN UCHAR SupRateLen,
	IN UCHAR ExtRate[],
	IN UCHAR ExtRateLen,
	IN UCHAR Channel,
	IN UCHAR Rssi,
	IN LARGE_INTEGER TimeStamp,
	IN UCHAR CkipFlag,
	IN PEDCA_PARM pEdcaParm,
	IN PQOS_CAPABILITY_PARM pQosCapability,
	IN PQBSS_LOAD_PARM pQbssLoad,
	IN UCHAR LengthVIE,
	IN PNDIS_802_11_VARIABLE_IEs pVIE);

ULONG  BssTableSetEntry(
	IN  PRTMP_ADAPTER   pAd,
	OUT PBSS_TABLE pTab,
	IN PUCHAR pBssid,
	IN CHAR Ssid[],
	IN UCHAR SsidLen,
	IN UCHAR BssType,
	IN USHORT BeaconPeriod,
	IN CF_PARM *CfParm,
	IN USHORT AtimWin,
	IN USHORT CapabilityInfo,
	IN UCHAR SupRate[],
	IN UCHAR SupRateLen,
	IN UCHAR ExtRate[],
	IN UCHAR ExtRateLen,
	IN UCHAR Channel,
	IN UCHAR Rssi,
	IN LARGE_INTEGER TimeStamp,
	IN UCHAR CkipFlag,
	IN PEDCA_PARM pEdcaParm,
	IN PQOS_CAPABILITY_PARM pQosCapability,
	IN PQBSS_LOAD_PARM pQbssLoad,
	IN UCHAR LengthVIE,
	IN PNDIS_802_11_VARIABLE_IEs pVIE);

VOID BssTableSsidSort(
	IN  PRTMP_ADAPTER   pAd,
	OUT BSS_TABLE *OutTab,
	IN  CHAR Ssid[],
	IN  UCHAR SsidLen);

VOID  BssTableSortByRssi(
	IN OUT BSS_TABLE *OutTab);

VOID BssCipherParse(
	IN OUT  PBSS_ENTRY  pBss);

NDIS_STATUS  MlmeQueueInit(
	IN MLME_QUEUE *Queue);

VOID  MlmeQueueDestroy(
	IN MLME_QUEUE *Queue);

BOOLEAN MlmeEnqueue(
	IN PRTMP_ADAPTER pAd,
	IN ULONG Machine,
	IN ULONG MsgType,
	IN ULONG MsgLen,
	IN VOID *Msg);

BOOLEAN MlmeEnqueueForRecv(
	IN	PRTMP_ADAPTER	pAd,
	IN UCHAR Rssi,
	IN ULONG MsgLen,
	IN VOID *Msg,
	IN UCHAR Signal);

BOOLEAN MlmeDequeue(
	IN MLME_QUEUE *Queue,
	OUT MLME_QUEUE_ELEM **Elem);

VOID    MlmeRestartStateMachine(
	IN  PRTMP_ADAPTER   pAd);

VOID	MlmePostRestartStateMachine(
	IN	PRTMP_ADAPTER	pAd);

BOOLEAN  MlmeQueueEmpty(
	IN MLME_QUEUE *Queue);

BOOLEAN  MlmeQueueFull(
	IN MLME_QUEUE *Queue);

BOOLEAN  MsgTypeSubst(
	IN PRTMP_ADAPTER pAd,
	IN PFRAME_802_11 pFrame,
	OUT INT *Machine,
	OUT INT *MsgType);

VOID StateMachineInit(
	IN STATE_MACHINE *Sm,
	IN STATE_MACHINE_FUNC Trans[],
	IN ULONG StNr,
	IN ULONG MsgNr,
	IN STATE_MACHINE_FUNC DefFunc,
	IN ULONG InitState,
	IN ULONG Base);

VOID StateMachineSetAction(
	IN STATE_MACHINE *S,
	IN ULONG St,
	ULONG Msg,
	IN STATE_MACHINE_FUNC F);

VOID StateMachinePerformAction(
	IN  PRTMP_ADAPTER   pAd,
	IN STATE_MACHINE *S,
	IN MLME_QUEUE_ELEM *Elem);

VOID Drop(
	IN  PRTMP_ADAPTER   pAd,
	IN MLME_QUEUE_ELEM *Elem);

VOID  AssocStateMachineInit(
	IN  PRTMP_ADAPTER   pAd,
	IN  STATE_MACHINE *Sm,
	OUT STATE_MACHINE_FUNC Trans[]);

VOID  ReassocTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID  AssocTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID  DisassocTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

//----------------------------------------------
VOID  MlmeDisassocReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  MlmeAssocReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  MlmeReassocReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  MlmeDisassocReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  PeerAssocRspAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  PeerReassocRspAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  PeerDisassocAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  DisassocTimeoutAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  AssocTimeoutAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  ReassocTimeoutAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  Cls3errAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR pAddr);

VOID SwitchBetweenWepAndCkip(
	IN PRTMP_ADAPTER pAd);

VOID  InvalidStateWhenAssoc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  InvalidStateWhenReassoc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID InvalidStateWhenDisassociate(
	IN  PRTMP_ADAPTER pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID  ComposePsPoll(
	IN  PRTMP_ADAPTER   pAd);

VOID  ComposeNullFrame(
	IN  PRTMP_ADAPTER pAd);

VOID  AssocPostProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR pAddr2,
	IN  USHORT CapabilityInfo,
	IN  USHORT Aid,
	IN  UCHAR SupRate[],
	IN  UCHAR SupRateLen,
	IN  UCHAR ExtRate[],
	IN  UCHAR ExtRateLen,
	IN  PEDCA_PARM pEdcaParm);

VOID AuthStateMachineInit(
	IN  PRTMP_ADAPTER   pAd,
	IN PSTATE_MACHINE sm,
	OUT STATE_MACHINE_FUNC Trans[]);

VOID AuthTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID MlmeAuthReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID PeerAuthRspAtSeq2Action(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID PeerAuthRspAtSeq4Action(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID AuthTimeoutAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID Cls2errAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR pAddr);

VOID MlmeDeauthReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID InvalidStateWhenAuth(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

//=============================================

VOID AuthRspStateMachineInit(
	IN  PRTMP_ADAPTER   pAd,
	IN  PSTATE_MACHINE Sm,
	IN  STATE_MACHINE_FUNC Trans[]);

VOID PeerDeauthAction(
	IN PRTMP_ADAPTER pAd,
	IN PMLME_QUEUE_ELEM Elem);

VOID PeerAuthSimpleRspGenAndSend(
	IN  PRTMP_ADAPTER   pAd,
	IN  PHEADER_802_11  pHdr80211,
	IN  USHORT Alg,
	IN  USHORT Seq,
	IN  USHORT Reason,
	IN  USHORT Status);

//========================================

void DlsStateMachineInit(
    IN PRTMP_ADAPTER pAd,
    IN STATE_MACHINE *Sm,
    OUT STATE_MACHINE_FUNC Trans[]);

VOID MlmeDlsReqAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

VOID PeerDlsReqAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

VOID PeerDlsRspAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

VOID MlmeDlsTearDownAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

VOID PeerDlsTearDownAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

VOID RTMPCheckDLSTimeOut(
	IN PRTMP_ADAPTER	pAd);

BOOLEAN RTMPRcvFrameDLSCheck(
	IN PRTMP_ADAPTER	pAd,
	IN PHEADER_802_11	pHeader,
	IN ULONG			Len);

BOOLEAN	RTMPCheckDLSFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN  PUCHAR          pDA);

VOID RTMPSendDLSTearDownFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN  PUCHAR          pDA);

NDIS_STATUS RTMPSendSTAKeyRequest(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			pDA);

NDIS_STATUS	RTMPSendSTAKeyHandShake(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			pDA);

VOID DlsTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID PeerDlsStaKeyAction(
    IN PRTMP_ADAPTER pAd,
    IN MLME_QUEUE_ELEM *Elem);

//========================================

VOID SyncStateMachineInit(
	IN  PRTMP_ADAPTER   pAd,
	IN  STATE_MACHINE *Sm,
	OUT STATE_MACHINE_FUNC Trans[]);

VOID BeaconTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID ScanTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID MlmeScanReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID InvalidStateWhenScan(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID InvalidStateWhenJoin(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID InvalidStateWhenStart(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID PeerBeacon(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID EnqueueProbeRequest(
	IN PRTMP_ADAPTER pAd);

VOID	RTMPSendNullFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			TxRate);

VOID RTMPSendHardEncryptFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			TxRate,
	IN  PCIPHER_KEY		pKey,
	IN	UCHAR			KeyTable,
	IN	UCHAR			KeyIdx,
	IN	PUCHAR			pFrame,
	IN	ULONG			FrameLen);

//=========================================

VOID MlmeCntlInit(
	IN  PRTMP_ADAPTER   pAd,
	IN  STATE_MACHINE *S,
	OUT STATE_MACHINE_FUNC Trans[]);

VOID MlmeCntlMachinePerformAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  STATE_MACHINE *S,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlIdleProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlOidScanProc(
	IN  PRTMP_ADAPTER pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlOidSsidProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM * Elem);

VOID CntlOidRTBssidProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM * Elem);

VOID CntlMlmeRoamingProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM * Elem);

VOID CntlOidDLSSetupProc(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem);

VOID CntlWaitDisassocProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlWaitJoinProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlWaitReassocProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlWaitStartProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlWaitAuthProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlWaitAuthProc2(
	IN  PRTMP_ADAPTER pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID CntlWaitAssocProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID LinkUp(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR BssType);

VOID LinkDown(
	IN  PRTMP_ADAPTER   pAd,
	IN  BOOLEAN         IsReqFromAP);

VOID MlmeCntlConfirm(
	IN PRTMP_ADAPTER pAd,
	IN ULONG MsgType,
	IN USHORT Msg);

VOID IterateOnBssTab(
	IN  PRTMP_ADAPTER   pAd);

VOID IterateOnBssTab2(
	IN  PRTMP_ADAPTER   pAd);;

VOID JoinParmFill(
	IN  PRTMP_ADAPTER   pAd,
	IN  OUT MLME_JOIN_REQ_STRUCT *JoinReq,
	IN  ULONG BssIdx);

VOID AssocParmFill(
	IN  PRTMP_ADAPTER   pAd,
	IN OUT MLME_ASSOC_REQ_STRUCT *AssocReq,
	IN  PUCHAR pAddr,
	IN  USHORT CapabilityInfo,
	IN  ULONG Timeout,
	IN  USHORT ListenIntv);

VOID ScanParmFill(
	IN  PRTMP_ADAPTER   pAd,
	IN  OUT MLME_SCAN_REQ_STRUCT *ScanReq,
	IN  CHAR Ssid[],
	IN  UCHAR SsidLen,
	IN  UCHAR BssType,
	IN  UCHAR ScanType);

VOID DlsParmFill(
	IN PRTMP_ADAPTER pAd,
	IN OUT MLME_DLS_REQ_STRUCT *DlsReq,
	IN PRT_802_11_DLS pDls,
	IN USHORT reason);

VOID DisassocParmFill(
	IN  PRTMP_ADAPTER   pAd,
	IN  OUT MLME_DISASSOC_REQ_STRUCT *DisassocReq,
	IN  PUCHAR pAddr,
	IN  USHORT Reason);

VOID StartParmFill(
	IN  PRTMP_ADAPTER   pAd,
	IN  OUT MLME_START_REQ_STRUCT *StartReq,
	IN  CHAR Ssid[],
	IN  UCHAR SsidLen);

VOID AuthParmFill(
	IN  PRTMP_ADAPTER   pAd,
	IN  OUT MLME_AUTH_REQ_STRUCT *AuthReq,
	IN  PUCHAR pAddr,
	IN  USHORT Alg);

VOID EnqueuePsPoll(
	IN  PRTMP_ADAPTER   pAd);

VOID EnqueueBeaconFrame(
	IN  PRTMP_ADAPTER   pAd);

VOID MlmeJoinReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID MlmeScanReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID MlmeStartReqAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID ScanTimeoutAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID BeaconTimeoutAtJoinAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID PeerBeaconAtScanAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID PeerBeaconAtJoinAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID PeerBeacon(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID PeerProbeReqAction(
	IN  PRTMP_ADAPTER pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID ScanNextChannel(
	IN  PRTMP_ADAPTER   pAd);

ULONG MakeIbssBeacon(
	IN  PRTMP_ADAPTER   pAd);

VOID CCXAdjacentAPReport(
	IN  PRTMP_ADAPTER   pAd);

BOOLEAN MlmeScanReqSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT UCHAR *BssType,
	OUT CHAR ssid[],
	OUT UCHAR *SsidLen,
	OUT UCHAR *ScanType);

BOOLEAN PeerBeaconAndProbeRspSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pAddr2,
	OUT PUCHAR pBssid,
	OUT CHAR Ssid[],
	OUT UCHAR *pSsidLen,
	OUT UCHAR *pBssType,
	OUT USHORT *pBeaconPeriod,
	OUT UCHAR *pChannel,
	OUT UCHAR *pNewChannel,
	OUT LARGE_INTEGER *pTimestamp,
	OUT CF_PARM *pCfParm,
	OUT USHORT *pAtimWin,
	OUT USHORT *pCapabilityInfo,
	OUT UCHAR *pErp,
	OUT UCHAR *pDtimCount,
	OUT UCHAR *pDtimPeriod,
	OUT UCHAR *pBcastFlag,
	OUT UCHAR *pMessageToMe,
	OUT UCHAR SupRate[],
	OUT UCHAR *pSupRateLen,
	OUT UCHAR ExtRate[],
	OUT UCHAR *pExtRateLen,
	OUT UCHAR *pCkipFlag,
	OUT UCHAR *pAironetCellPowerLimit,
	OUT PEDCA_PARM       pEdcaParm,
	OUT PQBSS_LOAD_PARM  pQbssLoad,
	OUT PQOS_CAPABILITY_PARM pQosCapability,
	OUT ULONG *pRalinkIe,
	OUT UCHAR *LengthVIE,
	OUT PNDIS_802_11_VARIABLE_IEs pVIE);

BOOLEAN MlmeAssocReqSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pApAddr,
	OUT USHORT *CapabilityInfo,
	OUT ULONG *Timeout,
	OUT USHORT *ListenIntv);

BOOLEAN MlmeAuthReqSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pAddr,
	OUT ULONG *Timeout,
	OUT USHORT *Alg);

BOOLEAN MlmeStartReqSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT CHAR Ssid[],
	OUT UCHAR *Ssidlen);

BOOLEAN PeerAuthSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pAddr,
	OUT USHORT *Alg,
	OUT USHORT *Seq,
	OUT USHORT *Status,
	OUT CHAR ChlgText[]);

BOOLEAN PeerAssocRspSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pAddr2,
	OUT USHORT *pCapabilityInfo,
	OUT USHORT *pStatus,
	OUT USHORT *pAid,
	OUT UCHAR SupRate[],
	OUT UCHAR *pSupRateLen,
	OUT UCHAR ExtRate[],
	OUT UCHAR *pExtRateLen,
	OUT PEDCA_PARM pEdcaParm,
	OUT UCHAR *pCkipFlag);

BOOLEAN PeerDisassocSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pAddr2,
	OUT USHORT *Reason);

BOOLEAN PeerDeauthSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pAddr2,
	OUT USHORT *Reason);

BOOLEAN PeerProbeReqSanity(
	IN  PRTMP_ADAPTER   pAd,
	IN  VOID *Msg,
	IN  ULONG MsgLen,
	OUT PUCHAR pAddr2,
	OUT CHAR Ssid[],
	OUT UCHAR *SsidLen);

BOOLEAN GetTimBit(
	IN  CHAR *Ptr,
	IN  USHORT Aid,
	OUT UCHAR *TimLen,
	OUT UCHAR *BcastFlag,
	OUT UCHAR *DtimCount,
	OUT UCHAR *DtimPeriod,
	OUT UCHAR *MessageToMe);

UCHAR ChannelSanity(
	IN PRTMP_ADAPTER pAd,
	IN UCHAR channel);

NDIS_802_11_NETWORK_TYPE NetworkTypeInUseSanity(
	IN UCHAR  Channel,
	IN UCHAR  SupRate[],
	IN UCHAR  SupRateLen,
	IN UCHAR  ExtRate[],
	IN UCHAR  ExtRateLen);

UCHAR PeerTxTypeInUseSanity(
	IN UCHAR  Channel,
	IN UCHAR  SupRate[],
	IN UCHAR  SupRateLen,
	IN UCHAR  ExtRate[],
	IN UCHAR  ExtRateLen);

NDIS_STATUS	RTMPWPAWepKeySanity(
	IN	PRTMP_ADAPTER	pAd,
	IN	PVOID			pBuf);

NDIS_STATUS	RTMPRemoveKeySanity(
	IN	PRTMP_ADAPTER	pAd,
	IN	PVOID			pBuf);

BOOLEAN MlmeDlsReqSanity(
	IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PRT_802_11_DLS *pDLS,
    OUT PUSHORT pReason);

BOOLEAN PeerDlsReqSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pDA,
    OUT PUCHAR pSA,
    OUT USHORT *pCapabilityInfo,
    OUT USHORT *pDlsTimeout);

BOOLEAN PeerDlsRspSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pDA,
    OUT PUCHAR pSA,
    OUT USHORT *pCapabilityInfo,
    OUT USHORT *pStatus);

BOOLEAN PeerDlsTearDownSanity(
    IN PRTMP_ADAPTER pAd,
    IN VOID *Msg,
    IN ULONG MsgLen,
    OUT PUCHAR pDA,
    OUT PUCHAR pSA,
    OUT USHORT *pReason);

ULONG MakeOutgoingFrame(
	OUT CHAR *Buffer,
	OUT ULONG *Length, ...);

VOID  LfsrInit(
	IN  PRTMP_ADAPTER   pAd,
	IN  ULONG Seed);

UCHAR RandomByte(
	IN  PRTMP_ADAPTER   pAd);

VOID MlmeSuspend(
	IN PRTMP_ADAPTER pAd,
	IN BOOLEAN linkdown);

VOID	MlmeResume(
	IN	PRTMP_ADAPTER	pAd);

VOID  MlmePeriodicExec(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID  MlmeTBTTExec(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID LinkDownExec(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID STAMlmePeriodicExec(
	IN PRTMP_ADAPTER pAd);

VOID MlmeAutoScan(
	IN PRTMP_ADAPTER pAd);

VOID MlmeAutoReconnectLastSSID(
	IN PRTMP_ADAPTER pAd);

BOOLEAN MlmeValidateSSID(
	IN PUCHAR pSsid,
	IN UCHAR  SsidLen);

BOOLEAN	MlmeIsVisibleSSID(
	IN PUCHAR   pSsid,
	IN UCHAR    SsidLen);

BOOLEAN	MlmeValidateSetSSID(
    IN PNDIS_802_11_SSID pOidSsid);

VOID MlmeCheckForRoaming(
	IN PRTMP_ADAPTER pAd,
	IN LARGE_INTEGER Now64);

VOID MlmeCheckForFastRoaming(
	IN  PRTMP_ADAPTER   pAd,
	IN  LARGE_INTEGER   Now64);

VOID MlmeDynamicTxRateSwitching(
	IN PRTMP_ADAPTER pAd);

VOID MlmeCalculateChannelQuality(
	IN PRTMP_ADAPTER pAd,
	IN LARGE_INTEGER Now64);

VOID MlmeCheckPsmChange(
	IN PRTMP_ADAPTER pAd,
	IN LARGE_INTEGER Now64);

VOID MlmeSetPsmBit(
	IN PRTMP_ADAPTER pAd,
	IN USHORT psm);

VOID MlmeSetTxPreamble(
	IN PRTMP_ADAPTER pAd,
	IN USHORT TxPreamble);

VOID MlmeUpdateTxRates(
	IN PRTMP_ADAPTER pAd,
	IN BOOLEAN       bLinkUp);

VOID RTMPCheckRates(
	IN      PRTMP_ADAPTER   pAd,
	IN OUT  UCHAR           SupRate[],
	IN OUT  UCHAR           *SupRateLen);

VOID AsicSetRxAnt(
	IN PRTMP_ADAPTER	pAd,
	IN UCHAR			Pair1,
	IN UCHAR			Pair2);

VOID AsicEvaluateSecondaryRxAnt(
	IN PRTMP_ADAPTER pAd);

VOID AsicRxAntEvalTimeout(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID AsicRxAntEvalAction(
	IN PRTMP_ADAPTER pAd);

VOID StaQuickResponeForRateUpExec(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID RadarDetectionStart(
	IN PRTMP_ADAPTER	pAd);

BOOLEAN RadarDetectionStop(
	IN PRTMP_ADAPTER	pAd);

BOOLEAN RadarChannelCheck(
	IN PRTMP_ADAPTER	pAd,
	IN UCHAR			Ch);

INT MlmeThread(
	IN PVOID Context);

NDIS_STATUS MlmeInit(
	IN  PRTMP_ADAPTER   pAd);

VOID MlmeHandler(
	IN  PRTMP_ADAPTER   pAd);

VOID MlmeHalt(
	IN  PRTMP_ADAPTER   pAd);

VOID BuildChannelList(
	IN PRTMP_ADAPTER pAd);

UCHAR FirstChannel(
	IN  PRTMP_ADAPTER   pAd);

UCHAR NextChannel(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR channel);

VOID ChangeToCellPowerLimit(
	IN PRTMP_ADAPTER pAd,
	IN UCHAR         AironetCellPowerLimit);

VOID RaiseClock(
	IN  PRTMP_ADAPTER   pAd,
	IN  ULONG *x);

VOID LowerClock(
	IN  PRTMP_ADAPTER   pAd,
	IN  ULONG *x);

USHORT ShiftInBits(
	IN  PRTMP_ADAPTER   pAd);

VOID ShiftOutBits(
	IN  PRTMP_ADAPTER   pAd,
	IN  USHORT data,
	IN  USHORT count);

VOID EEpromCleanup(
	IN  PRTMP_ADAPTER   pAd);

VOID EWDS(
	IN  PRTMP_ADAPTER   pAd);

VOID EWEN(
	IN  PRTMP_ADAPTER   pAd);

USHORT RTMP_EEPROM_READ16(
	IN  PRTMP_ADAPTER   pAd,
	IN  USHORT Offset);

VOID RTMP_EEPROM_WRITE16(
	IN  PRTMP_ADAPTER   pAd,
	IN  USHORT Offset,
	IN  USHORT Data);

//
// Prototypes of function definition in rtmp_tkip.c
//
VOID RTMPInitTkipEngine(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pTKey,
	IN  UCHAR           KeyId,
	IN  PUCHAR          pTA,
	IN  PUCHAR          pMICKey,
	IN  PUCHAR          pTSC,
	OUT PULONG          pIV16,
	OUT PULONG          pIV32);

VOID    RTMPInitMICEngine(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pKey,
	IN  PUCHAR          pDA,
	IN  PUCHAR          pSA,
	IN  UCHAR           UserPriority,
	IN  PUCHAR          pMICKey);

BOOLEAN RTMPTkipCompareMICValue(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pSrc,
	IN  PUCHAR          pDA,
	IN  PUCHAR          pSA,
	IN  PUCHAR          pMICKey,
	IN  UINT            Len);

VOID    RTMPCalculateMICValue(
	IN  PRTMP_ADAPTER   pAd,
	IN  PNDIS_PACKET    pPacket,
	IN  PUCHAR          pEncap,
	IN  PCIPHER_KEY     pKey);

BOOLEAN RTMPSoftDecryptTKIP(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR	pData,
	IN ULONG	DataByteCnt,
	IN UCHAR    UserPriority,
	IN PCIPHER_KEY	pWpaKey);

BOOLEAN RTMPSoftDecryptAES(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR	pData,
	IN ULONG	DataByteCnt,
	IN PCIPHER_KEY	pWpaKey);

BOOLEAN RTMPTkipCompareMICValueWithLLC(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pLLC,
	IN  PUCHAR          pSrc,
	IN  PUCHAR          pDA,
	IN  PUCHAR          pSA,
	IN  PUCHAR          pMICKey,
	IN  UINT            Len);

VOID    RTMPTkipAppendByte(
	IN  PTKIP_KEY_INFO  pTkip,
	IN  UCHAR           uChar);

VOID    RTMPTkipAppend(
	IN  PTKIP_KEY_INFO  pTkip,
	IN  PUCHAR          pSrc,
	IN  UINT            nBytes);

VOID    RTMPTkipGetMIC(
	IN  PTKIP_KEY_INFO  pTkip);

VOID RTMPTkipMixKey(
	IN UCHAR *key,
	IN UCHAR *ta,
	IN ULONG pnl,
	IN ULONG pnh,
	OUT UCHAR *rc4key,
	IN UINT *p1k);

NDIS_STATUS RTMPWPAAddKeyProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  PVOID           pBuf);

NDIS_STATUS RTMPWPARemoveKeyProc(
	IN  PRTMP_ADAPTER   pAd,
	IN  PVOID           pBuf);

VOID RTMPWPARemoveAllKeys(
	IN  PRTMP_ADAPTER   pAd);

VOID	RTMPSetDesiredRates(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	LONG			Rates);

VOID    RTMPSetPhyMode(
	IN  PRTMP_ADAPTER   pAd,
	IN  ULONG phymode);

VOID RTMPIndicateWPA2Status(
	IN  PRTMP_ADAPTER  pAd);

VOID	RTMPOPModeSwitching(
	IN	PRTMP_ADAPTER	pAd);

//
// prototype in wpa.c
//
BOOLEAN WpaMsgTypeSubst(
	IN  UCHAR   EAPType,
	OUT ULONG   *MsgType);

VOID WpaPskStateMachineInit(
	IN  PRTMP_ADAPTER       pAd,
	IN  STATE_MACHINE       *S,
	OUT STATE_MACHINE_FUNC Trans[]);

VOID WpaEAPOLKeyAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID    WpaPairMsg1Action(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID    WpaPairMsg3Action(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID    WpaGroupMsg1Action(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID    WpaMacHeaderInit(
	IN      PRTMP_ADAPTER   pAd,
	IN OUT  PHEADER_802_11  pHdr80211,
	IN      UCHAR           wep,
	IN      PUCHAR          pAddr1);

VOID    WpaHardTransmit(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pFrame,
	IN  ULONG           FrameLen);

VOID    HMAC_SHA1(
	IN  UCHAR   *text,
	IN  UINT    text_len,
	IN  UCHAR   *key,
	IN  UINT    key_len,
	IN  UCHAR   *digest);

VOID    PRF(
	IN  UCHAR   *key,
	IN  INT     key_len,
	IN  UCHAR   *prefix,
	IN  INT     prefix_len,
	IN  UCHAR   *data,
	IN  INT     data_len,
	OUT UCHAR   *output,
	IN  INT     len);

VOID    CCKMPRF(
	IN  UCHAR   *key,
	IN  INT     key_len,
	IN  UCHAR   *data,
	IN  INT     data_len,
	OUT UCHAR   *output,
	IN  INT     len);

VOID WpaCountPTK(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR   *PMK,
	IN  UCHAR   *ANonce,
	IN  UCHAR   *AA,
	IN  UCHAR   *SNonce,
	IN  UCHAR   *SA,
	OUT UCHAR   *output,
	IN  UINT    len);

VOID    GenRandom(
	IN  PRTMP_ADAPTER   pAd,
	OUT UCHAR           *random);

VOID    AES_GTK_KEY_UNWRAP(
	IN  UCHAR   *key,
	OUT UCHAR   *plaintext,
	IN  UCHAR   *ciphertext);

//
// extra prototype in md5.c
//
VOID    SHAInit(SHA_CTX *ctx);

VOID    SHAHashBlock(SHA_CTX *ctx);

VOID    SHAUpdate(SHA_CTX *ctx, unsigned char *dataIn, int len);

VOID    SHAFinal(SHA_CTX *ctx, unsigned char hashout[20]);

//
// prototype in aironet.c
//
VOID    AironetStateMachineInit(
	IN  PRTMP_ADAPTER       pAd,
	IN  STATE_MACHINE       *S,
	OUT STATE_MACHINE_FUNC  Trans[]);

VOID    AironetMsgAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID    AironetRequestAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID    ChannelLoadRequestAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Index);

VOID    NoiseHistRequestAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Index);

VOID    BeaconRequestAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Index);

VOID    AironetReportAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  MLME_QUEUE_ELEM *Elem);

VOID    ChannelLoadReportAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Index);

VOID    NoiseHistReportAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Index);

VOID    AironetFinalReportAction(
	IN  PRTMP_ADAPTER   pAd);

VOID    BeaconReportAction(
	IN  PRTMP_ADAPTER   pAd,
	IN  UCHAR           Index);

VOID    AironetAddBeaconReport(
	IN  PRTMP_ADAPTER       pAd,
	IN  ULONG               Index,
	IN  PMLME_QUEUE_ELEM    pElem);

VOID    AironetCreateBeaconReportFromBssTable(
	IN  PRTMP_ADAPTER       pAd);

CHAR    ConvertToRssi(
	IN PRTMP_ADAPTER  pAd,
	IN  UCHAR   Rssi,
	IN UCHAR    RssiNumber);

//
// function prototype in ap_wpa.c
//

BOOLEAN WPAMsgTypeSubst(
	IN UCHAR    EAPType,
	OUT ULONG *MsgType) ;

MAC_TABLE_ENTRY *PACInquiry(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pAddr,
	OUT NDIS_802_11_PRIVACY_FILTER   *Privacy,
	OUT AP_WPA_STATE       *WpaState);

BOOLEAN RTMPCheckWPAframe(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR pHeader,
	IN ULONG DataByteCount);

BOOLEAN RTMPCheckMcast(
	IN PRTMP_ADAPTER pAd,
	IN PEID_STRUCT      eid_ptr,
	IN MAC_TABLE_ENTRY  *pEntry);

BOOLEAN RTMPCheckUcast(
	IN PRTMP_ADAPTER pAd,
	IN PEID_STRUCT      eid_ptr,
	IN MAC_TABLE_ENTRY  *pEntry);

BOOLEAN RTMPCheckAUTH(
	IN PRTMP_ADAPTER pAd,
	IN PEID_STRUCT      eid_ptr,
	IN MAC_TABLE_ENTRY  *pEntry);

VOID WPAStart4WayHS(
	IN  PRTMP_ADAPTER   pAd,
	IN  MAC_TABLE_ENTRY *pEntry);

VOID APWpaEAPPacketAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem);

VOID APWpaEAPOLStartAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem);

VOID APWpaEAPOLLogoffAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem);

VOID APWpaEAPOLKeyAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem);

VOID APWpaEAPOLASFAlertAction(
	IN  PRTMP_ADAPTER    pAd,
	IN  MLME_QUEUE_ELEM  *Elem);

VOID HandleCounterMeasure(
	IN PRTMP_ADAPTER pAd,
	IN MAC_TABLE_ENTRY  *pEntry);

VOID PeerPairMsg2Action(
	IN PRTMP_ADAPTER pAd,
	IN MAC_TABLE_ENTRY  *pEntry,
	IN MLME_QUEUE_ELEM *Elem);

VOID CMTimerExec(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID EnqueueStartForPSKExec(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID WPARetryExec(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3);

VOID Wpa1PeerPairMsg4Action(
	IN PRTMP_ADAPTER pAd,
	IN MAC_TABLE_ENTRY  *pEntry,
	IN MLME_QUEUE_ELEM *Elem);

VOID Wpa2PeerPairMsg4Action(
	IN  PRTMP_ADAPTER    pAd,
	IN  PMAC_TABLE_ENTRY pEntry,
	IN  MLME_QUEUE_ELEM  *Elem);

VOID PeerGroupMsg2Action(
	IN  PRTMP_ADAPTER    pAd,
	IN  PMAC_TABLE_ENTRY pEntry,
	IN  VOID             *Msg,
	IN  UINT             MsgLen);

NDIS_STATUS WPAHardTransmit(
	IN  PRTMP_ADAPTER    pAd,
	IN  PMAC_TABLE_ENTRY pEntry);

VOID PairDisAssocAction(
	IN  PRTMP_ADAPTER    pAd,
	IN  PMAC_TABLE_ENTRY pEntry,
	IN  USHORT           Reason);

VOID DisAssocAction(
	IN  PRTMP_ADAPTER    pAd,
	IN  PMAC_TABLE_ENTRY pEntry,
	IN  USHORT           Reason);

VOID GREKEYPeriodicExec(
	IN  PVOID   SystemSpecific1,
	IN  PVOID   FunctionContext,
	IN  PVOID   SystemSpecific2,
	IN  PVOID   SystemSpecific3);

VOID WPAMacHeaderInit(
	IN  PRTMP_ADAPTER       pAd,
	IN  OUT PHEADER_802_11  Hdr,
	IN  UCHAR               wep,
	IN  PUCHAR              pAddr1);

VOID CountPTK(
	IN  UCHAR   *PMK,
	IN  UCHAR   *ANonce,
	IN  UCHAR   *AA,
	IN  UCHAR   *SNonce,
	IN  UCHAR   *SA,
	OUT UCHAR   *output,
	IN  UINT    len);

VOID CountGTK(
	IN  UCHAR   *PMK,
	IN  UCHAR   *GNonce,
	IN  UCHAR   *AA,
	OUT UCHAR   *output,
	IN  UINT    len);

VOID    GetSmall(
	IN  PVOID   pSrc1,
	IN  PVOID   pSrc2,
	OUT PUCHAR  out,
	IN  ULONG   Length);

VOID    GetLarge(
	IN  PVOID   pSrc1,
	IN  PVOID   pSrc2,
	OUT PUCHAR  out,
	IN  ULONG   Length);

VOID APGenRandom(
	IN PRTMP_ADAPTER pAd,
	OUT UCHAR       *random);

VOID AES_GTK_KEY_WRAP(
	IN UCHAR *key,
	IN UCHAR *plaintext,
	IN UCHAR p_len,
	OUT UCHAR *ciphertext);

VOID RTMPMakeRSNIE(
	IN  PRTMP_ADAPTER   pAd,
	IN  UINT            AuthMode,
	IN  UINT            WepStatus);

VOID    APToWirelessSta(
	IN  PRTMP_ADAPTER   pAd,
	IN  USHORT          Aid,
	IN  PUCHAR          pHeader802_3,
	IN  UINT            HdrLen,
	IN  PUCHAR          pData,
	IN  UINT            DataLen);

VOID MlmeFreeMemoryHandler(
	IN PRTMP_ADAPTER pAd);

NDIS_STATUS MlmeInitMemoryHandler(
	IN PRTMP_ADAPTER pAd,
	IN UINT  Number,
	IN UINT  Size);

NDIS_STATUS MlmeAllocateMemory(
	IN PRTMP_ADAPTER pAd,
	OUT PVOID        *AllocVa);

VOID    MlmeFreeMemory(
	IN PRTMP_ADAPTER pAd,
	IN PVOID         AllocVa);
//
// Function Prototype in rtusb_data.c
//
INT   RTMPSendPackets(
    struct sk_buff *skb, struct net_device *dev);

NDIS_STATUS	RTMPSendPacket(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket);

VOID RTMPDeQueuePacket(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			BulkOutPipeId);

NDIS_STATUS	RTUSBFreeDescriptorRequest(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			RingType,
	IN	UCHAR			BulkOutPipeId,
	IN	UCHAR			NumberRequired);

NDIS_STATUS Sniff2BytesFromNdisBuffer(
	IN  PNDIS_BUFFER    pFirstBuffer,
	IN  UCHAR           DesiredOffset,
	OUT PUCHAR          pByte0,
	OUT PUCHAR          pByte1);

void RTMP_QueryPacketInfo(
	IN  PNDIS_PACKET pPacket,
	OUT PACKET_INFO  *pPacketInfo,
	OUT PUCHAR		 *pSrcBufVA,
	OUT	UINT		 *pSrcBufLen);

VOID RTUSBRejectPendingPackets(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBSuspendMsduTransmission(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBResumeMsduTransmission(
	IN	PRTMP_ADAPTER	pAd);

USHORT RTUSBCalcDuration(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			Rate,
	IN	ULONG			Size);

VOID RTUSBWriteTxDescriptor(
	IN  PRTMP_ADAPTER pAd,
 	IN  PTXD_STRUC	pTxD,
	IN  UCHAR	CipherAlg,
	IN  UCHAR       KeyTable,
	IN  UCHAR       KeyIdx,
	IN  BOOLEAN	Ack,
	IN  BOOLEAN	Fragment,
	IN  BOOLEAN     InsTimestamp,
	IN  UCHAR	RetryMode,
	IN  UCHAR	Ifs,
	IN  UINT	Rate,
	IN  ULONG	Length,
	IN  UCHAR       QueIdx,
	IN  UCHAR       PID,
	IN  BOOLEAN     bAfterRTSCTS);

NDIS_STATUS RTUSBHardTransmit(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket,
	IN	UCHAR			NumberRequired,
	IN 	UCHAR	QueIndx);

#ifdef WIN_NDIS
VOID RTUSBRxPacket(
	IN	PRTMP_ADAPTER  pAd,
	IN	PRX_CONTEXT		pRxContext,
	IN	NTSTATUS		status);

VOID RTUSBAPHandleRxPacket(
	IN	PRTMP_ADAPTER  pAd,
	IN	PRX_CONTEXT		pRxContext,
	IN	NTSTATUS		status);
#else

VOID	    RTUSBBulkRxHandle(
    IN	 unsigned long data);

VOID        RTUSBAPHandleRxPacket(
    IN	 unsigned long data);

VOID	RTUSBRxPacket(
	IN	 unsigned long data);
#endif

VOID RTUSBDequeueMLMEPacket(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBCleanUpMLMEWaitQueue(
	IN	PRTMP_ADAPTER	pAd);

NDIS_STATUS	RTMPCheckRxDescriptor(
	IN	PRTMP_ADAPTER	pAd,
	IN	PHEADER_802_11	pHeader,
	IN	PRXD_STRUC	pRxD);

VOID RTUSBWriteBeaconDescriptor(
	IN  PRTMP_ADAPTER pAd,
	IN	PTXD_STRUC	pTxD,
	IN	UINT		Length,
	IN	UINT		Rate);

VOID RTUSBMlmeHardTransmit(
	IN	PRTMP_ADAPTER	pAd,
	IN	PMGMT_STRUC		pMgmt);

#ifdef WIN_NDIS
VOID RTUSBBulkOutPsPollComplete(
	IN	PDEVICE_OBJECT	DeviceObject,
	IN	PIRP			pIrp,
	IN	PVOID			pContext);

VOID RTUSBCleanUpDataBulkOutQueue(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBCancelPendingBulkOutIRP(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBBulkOutDataPacket(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			BulkOutPipeId,
	IN	UCHAR			Index);
#endif

VOID RTUSBInitTxDesc(
	IN	PRTMP_ADAPTER			pAd,
	IN	PTX_CONTEXT				pTxContext,
	IN	UCHAR					BulkOutPipeId,
	IN	usb_complete_t	Func);

#ifdef WIN_NDIS
NTSTATUS RTUSBBulkOutDataPacketComplete(
	IN	PDEVICE_OBJECT	DeviceObject,
	IN	PIRP			pIrp,
	IN	PVOID			pContext);

VOID RTUSBBulkOutNullFrame(
	IN	PRTMP_ADAPTER	pAd);

NTSTATUS RTUSBBulkOutNullFrameComplete(
	IN	PDEVICE_OBJECT	DeviceObject,
	IN	PIRP			pIrp,
	IN	PVOID			pContext);

VOID RTUSBBulkOutRTSFrame(
	IN	PRTMP_ADAPTER	pAd);

NTSTATUS RTUSBBulkOutRTSFrameComplete(
	IN	PDEVICE_OBJECT	DeviceObject,
	IN	PIRP			pIrp,
	IN	PVOID			pContext);

#endif

VOID RTUSBCancelPendingBulkInIRP(
	IN	PRTMP_ADAPTER	pAd);

VOID	RTUSBCancelPendingBulkOutIRP(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBCancelPendingIRPs(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBBulkOutMLMEPacket(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			Index);

#ifdef WIN_NDIS
NTSTATUS RTUSBBulkOutMLMEPacketComplete(
	IN	PDEVICE_OBJECT	DeviceObject,
	IN	PIRP			pIrp,
	IN	PVOID			pContext);

VOID RTUSBBulkOutPsPoll(
	IN	PRTMP_ADAPTER	pAd);


VOID RTUSBBulkOutSpecialData(
	IN	PRTMP_ADAPTER	pAd);

NTSTATUS RTUSBBulkOutSpecialDataComplete(
	IN	PDEVICE_OBJECT	DeviceObject,
	IN	PIRP			pIrp,
	IN	PVOID			pContext);

#endif

VOID RTUSBCleanUpMLMEBulkOutQueue(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBKickBulkOut(
	IN	PRTMP_ADAPTER pAd);

VOID	RTUSBCleanUpDataBulkOutQueue(
	IN	PRTMP_ADAPTER	pAd);

VOID	RTUSBBulkReceive(
	IN	PRTMP_ADAPTER	pAd);

#ifdef WIN_NDIS
NTSTATUS RTUSBBulkRxComplete(
	IN	PDEVICE_OBJECT	DeviceObject,
	IN	PIRP			pIrp,
	IN	PVOID			Context);
#endif

VOID RTUSBInitRxDesc(
	IN	PRTMP_ADAPTER	pAd,
	IN  PRX_CONTEXT		pRxContext);

BOOLEAN TxFrameIsAggregatible(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pPrevAddr1,
	IN  PUCHAR          p8023hdr);


//
// Function Prototype in rtusb_io.c
//
NTSTATUS RTUSBMultiRead(
	IN	PRTMP_ADAPTER	pAd,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS RTUSBMultiWrite(
	IN	PRTMP_ADAPTER	pAd,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS RTUSBSetLED(
	IN	PRTMP_ADAPTER		pAd,
	IN	MCU_LEDCS_STRUC		LedStatus,
	IN	USHORT				LedIndicatorStrength);

NTSTATUS RTUSBReadBBPRegister(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			Id,
	IN	PUCHAR			pValue);

NTSTATUS RTUSBWriteBBPRegister(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			Id,
	IN	UCHAR			Value);

NTSTATUS RTUSBWriteRFRegister(
	IN	PRTMP_ADAPTER	pAd,
	IN	ULONG			Value);

NTSTATUS RTUSB_CallUSBD(
	IN	PRTMP_ADAPTER	pAd,
	IN	PURB			Urb);

NTSTATUS RTUSB_VendorRequest(
	IN	PRTMP_ADAPTER	pAd,
	IN	ULONG			TransferFlags,
	IN	UCHAR			ReservedBits,
	IN	UCHAR			Request,
	IN	USHORT			Value,
	IN	USHORT			Index,
	IN	PVOID			TransferBuffer,
	IN	ULONG			TransferBufferLength);

NTSTATUS RTUSB_ConfigureDevice(
	IN	PRTMP_ADAPTER	Adapter);

NTSTATUS RTUSB_GetDeviceDescriptor(
	IN	PRTMP_ADAPTER	Adapter);

VOID RTUSB_FreeDeviceDescriptor(
	IN	PRTMP_ADAPTER	pAd);

#ifdef WIN_NDIS
VOID RTUSB_FreeConfigDescriptor(
	IN	PUSB_CONFIGURATION_DESCRIPTOR	pConfigDesc);

PUSB_CONFIGURATION_DESCRIPTOR RTUSB_GetConfigDescriptor(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSB_FreeInterfaceList(
	IN	PUSBD_INTERFACE_LIST_ENTRY	pInterfaceList,
	IN	ULONG						NumInterfaces);

PUSBD_INTERFACE_LIST_ENTRY RTUSB_GetInterfaceList(
	IN	PRTMP_ADAPTER					pAd,
	IN	PUSB_CONFIGURATION_DESCRIPTOR	pConfigDesc);

VOID RTUSB_FreeConfigUrb(
	IN	PURB	pUrb);

NTSTATUS RTUSB_SelectConfiguration(
	IN	PRTMP_ADAPTER					pAd,
	IN	PUSB_CONFIGURATION_DESCRIPTOR	pConfigDesc,
	IN	PUSBD_INTERFACE_LIST_ENTRY		pInterfaceList,
	OUT	PURB							*pConfigReqUrb);

NTSTATUS RTUSB_ConfigurePipes(
	IN	PRTMP_ADAPTER				pAd,
	IN	PUSBD_INTERFACE_INFORMATION	pInterface);

#endif

NTSTATUS RTUSB_ResetPort(
	IN	PRTMP_ADAPTER	Adapter);

NTSTATUS RTUSB_AbortPipe(
	IN	PRTMP_ADAPTER	pAd,
	IN  ULONG           PipeId);

NTSTATUS RTUSB_GetPortStatus(
	IN	PRTMP_ADAPTER	pAd,
	IN OUT PULONG     PortStatus);

BOOLEAN	RTUSB_InterfaceStart(
	IN	PRTMP_ADAPTER	Adapter);

VOID RTUSB_InterfaceStop(
	IN	PRTMP_ADAPTER	Adapter);

NTSTATUS RTUSB_ResetPipe(
	IN	PRTMP_ADAPTER	pAd,
	IN	UINT			BulkPipe);

NTSTATUS RTUSBReadEEPROM(
	IN	PRTMP_ADAPTER	pAd,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS RTUSBWriteEEPROM(
	IN	PRTMP_ADAPTER	pAd,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS RTUSBPutToSleep(
	IN	PRTMP_ADAPTER	pAd);

NTSTATUS RTUSBWakeUp(
	IN	PRTMP_ADAPTER	pAd);

VOID RTUSBInitializeCmdQ(
	IN	PCmdQ	cmdq);

NDIS_STATUS	RTUSBEnqueueCmdFromNdis(
	IN	PRTMP_ADAPTER	pAd,
	IN	NDIS_OID		Oid,
	IN	BOOLEAN			SetInformation,
	IN	PVOID			pInformationBuffer,
	IN	ULONG			InformationBufferLength);

NDIS_STATUS RTUSBEnqueueInternalCmd(
	IN	PRTMP_ADAPTER	pAd,
	IN NDIS_OID			Oid,
	IN PVOID			pInformationBuffer,
	IN ULONG			InformationBufferLength);

VOID RTUSBDequeueCmd(
	IN	PCmdQ		cmdq,
	OUT	PCmdQElmt	*pcmdqelmt);

VOID ReleaseAdapter(
	IN	PRTMP_ADAPTER pAd,
    IN  BOOLEAN         IsFree,
	IN  BOOLEAN         IsOnlyTx);

VOID CreateThreads(
	IN  struct net_device *net_dev);

VOID ControlThread(
    IN OUT PVOID Context);

INT RTUSBCmdThread(
	IN OUT PVOID Context);

NTSTATUS RTUSBWriteMACRegister(
	IN	PRTMP_ADAPTER	pAd,
	IN	USHORT			Offset,
	IN	ULONG			Value);

NTSTATUS RTUSBReadMACRegister(
	IN	PRTMP_ADAPTER	pAd,
	IN	USHORT			Offset,
	OUT	PULONG			pValue);

NTSTATUS RTUSBFirmwareRun(
	IN	PRTMP_ADAPTER	pAd);

NDIS_STATUS RTUSBSetHardWareRegister(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PVOID			pBuf);

NDIS_STATUS RTUSBQueryHardWareRegister(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PVOID			pBuf);

VOID CMDHandler(
	IN PRTMP_ADAPTER pAd);

#endif  // __RTMP_H__

