#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "errcode.h"
#include "AGC_LIB.h"
#include "defines.h"

static int canFd = -1; // File descriptor of /dev/can0

/*****************************************************************************************************************/
/*                         FOR AGC PCI FUN                                 */
/*****************************************************************************************************************/
unsigned int sendCanMessages( canmsg_t* Buffer, u8 Count)
{
  int result = -1;

  if( canFd == -1 ) {
    canFd = open("/dev/can0", O_RDWR);

    if( canFd == -1 )
      return ERROR_API_CAN_OPEN_FAIL;
  }

  result = write(canFd, Buffer, Count);

  if( result == -1 )
    return ERROR_API_CANSENDMESSAGES;
  else
    return ERROR_API_SUCC;
}

unsigned int getCanMessages( canmsg_t* Buffer, u8 Count)
{
  int result = -1;

  if( canFd == -1 ) {
    canFd = open("/dev/can0", O_RDWR);

    if( canFd == -1 )
      return ERROR_API_CAN_OPEN_FAIL;
  }

  result = read(canFd, Buffer, Count);
  if( result == -1 ) 
    return ERROR_API_CANGETMESSAGES;
  else
    return ERROR_API_SUCC;
}

unsigned int configCan( int Baud)
{
  Config_par_t can_config;
  Command_par_t can_cmd;
  int result = -1;

  if( canFd == -1 ) {
    canFd = open("/dev/can0", O_RDWR);

    if( canFd == -1 )
      return ERROR_API_CAN_OPEN_FAIL;
  }

  if( (Baud != 10) && (Baud != 20) && (Baud != 50) && (Baud != 100) && (Baud != 125) && (Baud != 250) && (Baud != 500) && 
      (Baud != 800) && (Baud != 1000) )
    return ERRMSG(ERROR_API_CANCONFIG, ERROR_GEN_INPUT_DATA);

  can_cmd.cmd = CMD_STOP;
  result = ioctl(canFd, ARBIOC_CAN_COMMAND, &can_cmd);
  if( result == -1 )
    return ERROR_GEN_DEVICE_FAIL;

  result = -1;
  can_config.target = CONF_TIMING; 
  can_config.val1   = Baud;
  result = ioctl(canFd, ARBIOC_CAN_CONFIG, &can_config);
  if( result == -1 )
    return ERROR_GEN_DEVICE_FAIL;
    

  result = -1;
  can_cmd.cmd = CMD_START;
  result = ioctl(canFd, ARBIOC_CAN_COMMAND, &can_cmd);
  if( result == -1 )
    return ERROR_GEN_DEVICE_FAIL;

  return ERROR_API_SUCC;
}
