<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">
<xsl:output method="html" />
    <xsl:template match="/relnotes/revisions">
        <html>
            <head>
            <title>
                <xsl:value-of select="@product" />&#160;<xsl:value-of select="@component" />&#160;Release&#160;Notes
            </title>
            </head>
        <body>
        <style type="text/css">
                .tg       {width:800px;
                           border:1px solid aaa;
                           background-color:ecf8ff;}
                
                .tg caption{text-align:left}
                
                .tg td    {text-align:center; font-family:Calibri; font-size:12px;
                           background-color:ffffff;
                           padding:5px;
                           border: 1px solid cccccc;
                           overflow:hidden;
                           word-break:normal;}
                
                .tg .des  {text-align:left; font-family:Calibri; font-size:12px;
                           padding:5px 10px;
                           border: 1px solid cccccc;
                           overflow:hidden;
                           word-break:normal;}
                
                .tg .gro  {text-align:left; font-family:Calibri; font-size:12px;
                           background-color:ecf8ff;
                           border:0px;
                           padding:5px;}
                
                .tg .revi {background-color:6598cb;
                           text-align:center; font-family:Calibri; font-size:12px;
                           padding:5px 10px;
                           border: 1px solid cccccc;
                           overflow:hidden;
                           word-break:normal;}
                
                .tg th    {background-color:6598cb;
                           font-family:Calibri; font-size:16px; font-weight:bold;
                           padding:5px;
                           border: 1px solid cccccc;
                           overflow:hidden;}
                
                .divhead  {background-color:336699;
                           text-align:center; font-family:calibri; font-size:20px; font-weight:bold;
                           color:efeeef;
                           padding:5px 10px;}
                
                .sum      {font-family:calibri; font-size:14px}
                
                DIV       {font-family:calibri; font-size:16px;
                           padding:15px;}
            </style>
            <DIV class="divhead">
                <span>
                    <xsl:value-of select="@product" /><span>&#160;</span>
                    <xsl:value-of select="@currentBuild" /><span>&#160;</span>
                    <xsl:value-of select="@component" />
                    <span>&#160;Release&#160;Notes</span>
                </span>
            </DIV>
            <DIV>
                <span>
                <p><span>Show&#160;changes&#160;from&#160;version&#160;</span>
                    <xsl:value-of select="@product" /><span>&#160;</span><B><xsl:value-of select="@bBase" />.<xsl:value-of select="@minR" /></B><span>&#160;to&#160;</span>
                    <xsl:value-of select="@product" /><span>&#160;</span><B><xsl:value-of select="@bBase" />.<xsl:value-of select="@maxR" /></B>
                </p></span>
                <table class="sum">
                    <tr>
                        <td>RCRs implemented</td>
                        <td>:</td>
                        <td><xsl:value-of select="@amountRcrs" /></td>
                    </tr>
                    <tr>
                        <td>Bugs fixed</td>
                        <td>:</td>
                        <td><xsl:value-of select="@amountBugs" /></td>
                    </tr>
                </table>
            </DIV>
            <DIV style="display:flex;align-items: center;">
                <table class="tg">
                <caption>Release notes:</caption>
                    <tr>
                        <th>ID</th>
                        <th>Revision</th>
                        <th>Description</th>
                    </tr>
                    <tr>
                        <td class="gro">
                        <span><B>RCRs:</B></span>
                        </td>
                    </tr>
                    <xsl:apply-templates select="rev[@atype = 'rcr']" />
                    <tr colspan="3">
                        <td class="gro">
                        <span><B>BUGs:</B></span>
                        </td>
                    </tr>
                    <xsl:apply-templates select="rev[@atype = 'bug']" />
                    <tr colspan="3">
                        <td class="gro">
                        <span><B>Notes:</B></span>
                        </td>
                    </tr>
                    <xsl:apply-templates select="rev[@atype = 'ote']" />
                </table>
            </DIV>
        </body>
        </html>
    </xsl:template>

    <xsl:template match="rev">
        <tr>
        <td>
            <span>
                <xsl:element name="a">
                    <xsl:attribute name="href">
                        <xsl:value-of select="@link" /><xsl:value-of select="@id" />
                    </xsl:attribute>
                    <xsl:value-of select="@id" />
                </xsl:element>
                
                <xsl:if test="@id = ''">
                <xsl:text>Rev.</xsl:text>
                </xsl:if>
            </span>
        </td>
        <td class="revi">
            <span>
                <xsl:value-of select="../@bBase" />.<xsl:value-of select="@revId" />
            </span>
        </td>
        <td class="des">
            <span>
                <xsl:value-of select="." />
            </span>
        </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>
