// encintelDlg.cpp : implementation file
//

#include "stdafx.h"
#include "encaac.h"
#include "encaacDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static VOID DBG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[SC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

static fstream * s_f_out_aac = NULL;

static BOOL on_process_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	CEncaacDlg * pMainDialog = (CEncaacDlg * )(CEncaacApp::s_p_common_enc_dlg_);

	return true;
}

static BOOL on_process_audio_buffer_ex( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	CEncaacDlg * pMainDialog = (CEncaacDlg * )(CEncaacApp::s_p_common_enc_dlg_);

	::EnterCriticalSection( &pMainDialog->m_hAudioStreamCriticalSection );

	if( 0x00000001 == pMainDialog->m_nFileRendererRecordState )
	{
		ULONGLONG n_src_sample_time = (ULONGLONG)(dSampleTime * 10000000);

		ULONGLONG n_dst_sample_time = 0;

		BYTE * pStreamBuffer = NULL;

		ULONG  nStreamBufferSize = 0;

		AMESDK_CODEC_ENCODE( pMainDialog->m_hAudioAACEncoderDev, pBuffer, nBufferLen, &pStreamBuffer, &nStreamBufferSize, n_src_sample_time, &n_dst_sample_time );

		if( NULL != pStreamBuffer && 0 < nStreamBufferSize ) 
		{
			if( s_f_out_aac )
			{					
				s_f_out_aac->write( (LPCSTR)pStreamBuffer, nStreamBufferSize );				
			}
		}
	}	
	::LeaveCriticalSection( &pMainDialog->m_hAudioStreamCriticalSection );

	return TRUE;
}

static BOOL on_process_audio_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	BOOL returns = on_process_audio_buffer_ex( dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData );

	return returns;
}

/////////////////////////////////////////////////////////////////////////////
// CEncaacDlg dialog

CEncaacDlg::CEncaacDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEncaacDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEncaacDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev = 0xFFFFFFFF;
	
	m_hAudioDev = 0xFFFFFFFF;

	m_hAudioAACEncoderDev = 0xFFFFFFFF;
	
	m_nVideoFrameWidth = 0;
	
	m_nVideoFrameHeight = 0;
	
	m_dVideoFrameRate = 0;
	
	m_nFileRendererRecordState = 0x00000000;	
}

void CEncaacDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEncaacDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEncaacDlg, CDialog)
	//{{AFX_MSG_MAP(CEncaacDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND_RANGE(ID_MENU_POPUP_FILE_STATE_BEG, ID_MENU_POPUP_FILE_STATE_END, OnMenuFileStateClick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEncaacDlg message handlers

BOOL CEncaacDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	CEncaacApp::s_p_common_enc_dlg_ = this;

	// [2014.11.19] [HUENGPEI@YUAN.COM.TW] INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	
	// INITIALIZE USER INTERFACE RESOURCE
	//
	InitMainDialog();

	// [2014.11.19] [HUENGPEI@YUAN.COM.TW] INITIALIZE DEVICE RESOURCE
	//
	HwInitialize();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CEncaacDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CEncaacDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CEncaacDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CEncaacDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}


BOOL CEncaacDlg::CloseFileStream( fstream *& fout )
{
	BOOL bRet = FALSE;

	if( fout )
	{
		fout->close();

		if( fout->fail() )
		{
			DBG("Failed to : %s\r\n\tLine: %d\r\n", "CloseFileStream::FAIL()", __LINE__ );
		}
		
		delete fout;
		
		fout = NULL;

		bRet = TRUE;
	}

	return bRet;
}

BOOL CEncaacDlg::InitMainDialog()
{
	ULONG nScreenWidth = GetSystemMetrics( SM_CYSCREEN );

	ULONG nScreenHeight = GetSystemMetrics( SM_CXSCREEN );

	CRect oWindowRect; GetWindowRect( &oWindowRect );
	
	CRect oClientRect; GetClientRect( &oClientRect );
	
	ULONG cx = oWindowRect.Width() - oClientRect.Width();				// GET DEFAULT BOUNDARY WIDTH OF DIALOG
	
	ULONG cy = oWindowRect.Height() - oClientRect.Height();				// GET DEFAULT BOUNDARY HEIGHT OF DIALOG
	
	SetWindowPos( &(CWnd::wndTop), (nScreenWidth - CAP_DIALOG_WIDTH) / 2, ( nScreenHeight - CAP_DIALOG_WIDTH ) / 2, CAP_DIALOG_WIDTH + (cx), CAP_DIALOG_HEIGHT + (cy), SWP_NOMOVE );

	CenterWindow();

	SetWindowText( CAP_PRODUCT );

	return true;
}

BOOL CEncaacDlg::HwUnInitialize()
{
	if( m_hVideoDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev ); m_hVideoDev = 0xFFFFFFFF; }

	if( m_hAudioDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev ); m_hAudioDev = 0xFFFFFFFF; }

	if( m_hAudioAACEncoderDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioAACEncoderDev ); m_hAudioAACEncoderDev = 0xFFFFFFFF; }

	::DeleteCriticalSection( &m_hAudioStreamCriticalSection );

	return true;
}

BOOL CEncaacDlg::StopRecording()
{
	::EnterCriticalSection( &m_hAudioStreamCriticalSection );

	m_nFileRendererRecordState = 0x00000000;

	::LeaveCriticalSection( &m_hAudioStreamCriticalSection );

	if( !CloseFileStream( s_f_out_aac ) )
	{
		DBG("Failed to : %s\r\n\tLine: %d\r\n", "StopRecording::FAIL()", __LINE__ );
	}

	return true;
}

BOOL CEncaacDlg::StartRecording()
{
	CHAR psz[ MAX_PATH ];
	
	::GetModuleFileName( NULL, psz, MAX_PATH );
	
	psz[ strlen( psz ) - 10 ] = '\0';

	{	SYSTEMTIME system_times; 

		::GetLocalTime( &system_times );
		
		CHAR szHead[ MAX_PATH ];
		
		lstrcpy( szHead, "_ADTS_");

		{	CHAR szAAC[ MAX_PATH ];
			
			sprintf( szAAC, "%s%s_CH%02d_%04d%02d%02d%02d%02d%02d.AAC", psz, szHead, 0 + 1, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

			s_f_out_aac = new fstream( szAAC, std::ios::out | std::ios::binary | std::ios::trunc );

			if( s_f_out_aac )
			{
				if( s_f_out_aac->fail() )
				{ 
					CloseFileStream( s_f_out_aac );

					DBG("Failed to : %s\r\n\tLine: %d\r\n", "StartRecording::FAIL()", __LINE__ );

					return false;
				}
			}
		}

		m_nFileRendererRecordState = 0x00000001;
	}

	return true;
}

BOOL CEncaacDlg::HwInitialize()
{
	HWND hPreviewWindow = NULL;

	PF_BUFFER_CALLBACK pfVideoPreviewBC = NULL;

	PF_BUFFER_CALLBACK pfAudioPreviewBC = NULL;
	
	// [2014.11.19] [HUENGPEI@YUAN.COM.TW] GET DEVICE PARAMETERS
	//
	ULONG standard = 0x01;
	
	ULONG cx = 1920;
	
	ULONG cy = 1080;
	
	ULONG quality = 8000;
	
	ULONG bitrate = 12*1024*1024;
	
	ULONG gop = 30;
	
	double fps = (0x10 == standard)?25.00 :29.97;

	::InitializeCriticalSection( &m_hAudioStreamCriticalSection );

	DBG( "CH01 FRAME RATE = %2.6f", m_dVideoFrameRate );
	
	ULONG deinterlace = 0x01;
	
	ULONG mode = 1;		// vbr = 0, cbr = 1, hbr = 2

	hPreviewWindow = m_hWnd;

	pfVideoPreviewBC = on_process_video_buffer;

	pfAudioPreviewBC = on_process_audio_buffer;

	m_hVideoDev = AMESDK_CREATE( "SA7160 PCI", 0, 0, hPreviewWindow, pfVideoPreviewBC, (PVOID)0 );

	m_hAudioDev = AMESDK_CREATE( "SA7160 PCI, Analog WaveIn", 0, 0, hPreviewWindow, pfAudioPreviewBC, (PVOID)0 ); 

	m_hAudioAACEncoderDev = AMESDK_CREATE( "Common Analog Encoder (AAC.ADTS)", 0, 7, NULL, NULL, NULL ); 

	if( m_hVideoDev & 0x80000000 ) { m_hVideoDev = 0xFFFFFFFF; }

	if( m_hAudioDev & 0x80000000 ) { m_hAudioDev = 0xFFFFFFFF; }

	if( m_hAudioAACEncoderDev & 0x80000000 ) { m_hAudioAACEncoderDev = 0xFFFFFFFF; }

	// SETUP LIVE PATH PROPERTIES
	// 		
	AMESDK_SET_STANDARD( m_hVideoDev, standard ); // STANDARD
	
	AMESDK_SET_FORMAT( m_hVideoDev, MAKEFOURCC('Y', 'U', 'Y', '2'), 1920, 1080, 16, fps );					
	
	AMESDK_SET_DEINTERLACE( m_hVideoDev, (cy > 288)?(deinterlace):(0x00000000) );

	// SETUP AUDIO PATH (AAC) PROPERTIES
	//
	AMESDK_SET_FORMAT( m_hAudioAACEncoderDev, 2, 16, 48000 );
	
	// SETUP AUDIO PATH (PCM) PROPERTIES
	//		
	AMESDK_SET_FORMAT( m_hAudioDev, 2, 16, 48000 );	

	AMESDK_SET_VOLUME( m_hAudioDev, 100 );

	// START
	//
	m_nVideoFrameWidth = cx;
	
	m_nVideoFrameHeight = cy;
	
	m_dVideoFrameRate = fps;
	
	AMESDK_RUN( m_hVideoDev );

	AMESDK_RUN( m_hAudioDev );

	AMESDK_RUN( m_hAudioAACEncoderDev );
	
	return true;
}

void CEncaacDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	StopRecording();

	HwUnInitialize();

	// [2014.11.19] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();	
}

void CEncaacDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	
}

void CEncaacDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnLButtonDown(nFlags, point);	
	
	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x, point.y ) );	

	CDialog::OnLButtonDown(nFlags, point);
}

void CEncaacDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	ClientToScreen( &point );

	if( 0xFFFFFFFF == m_hVideoDev ) { return; }

	CMenu menu_main;

	menu_main.CreatePopupMenu();

	CMenu menu_file_state;

	menu_file_state.CreatePopupMenu();

	menu_file_state.AppendMenu( MF_STRING, ID_MENU_POPUP_FILE_STATE_BEG + 0, "STOP" );

	menu_file_state.AppendMenu( MF_STRING, ID_MENU_POPUP_FILE_STATE_BEG + 1, "RUN" );
	
	menu_file_state.CheckMenuItem( structUserProperty_.n_file_state_, MF_BYPOSITION | MF_CHECKED );

	menu_file_state.SetDefaultItem( structUserProperty_.n_file_state_, TRUE );

	menu_file_state.EnableMenuItem( structUserProperty_.n_file_state_, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );

	menu_main.AppendMenu( MF_POPUP | MF_STRING, (UINT)menu_file_state.m_hMenu, "RECORD STATE" );

	menu_main.TrackPopupMenu( TPM_RIGHTBUTTON, point.x, point.y, this );
	
	CDialog::OnRButtonDown(nFlags, point);
}

void CEncaacDlg::OnMenuFileStateClick( UINT nID )
{
	if( 0xFFFFFFFF == m_hAudioAACEncoderDev ) {	return; }

	ULONG nFileState = nID & 0xF;

	structUserProperty_.n_file_state_ = nFileState;

	if( nFileState )
	{		
		StartRecording();
	}
	else
	{
		StopRecording();
	}

//	DBG("Failed to : %s\r\n\tnFileState: %d\r\n\t", "OnMenuFileStateClick", structUserProperty_.n_file_state_ );
}
