// AnalogDeviceVideoGraph.h: interface for the CAnalogDeviceVideoGraph class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANALOGDEVICEVIDEOGRAPH_H__AE76E803_E285_4895_B23A_D1E837862578__INCLUDED_)
#define AFX_ANALOGDEVICEVIDEOGRAPH_H__AE76E803_E285_4895_B23A_D1E837862578__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Graph.h"

class CAnalogDeviceVideoGraph : public CGraph  
{
public:

	CAnalogDeviceVideoGraph();

	virtual ~CAnalogDeviceVideoGraph();

public:

	// DEBUGGING FUNCTIONS
	//
	VOID					  SC_DEBUG( CHAR * fmt, ... );

	// MEMBER FUNCTIONS
	//
	BOOL					  Close( BOOL bDumpDebugMessage = TRUE );

	BOOL					  Create( PWSTR pwszDevName, PF_BUFFER_CALLBACK pBufferCBs[ 32 ], PVOID pUserDatas[ 32 ] );

	// MEMBER VARIABLES
	// 
	IBaseFilter *             m_pCaptureSourceBaseFilters[ 32 ];

	IBaseFilter *             m_pSampleGrabberBaseFilters[ 32 ];

	IAMAnalogVideoDecoder *   m_pAMAnalogVideoDecoders[ 32 ];

	IAMStreamConfig *		  m_pAMStreamConfigs[ 32 ];

	CSampleGrabber			  m_oSampleGrabbers[ 32 ];

	ISampleGrabber * 		  m_pSampleGrabbers[ 32 ];
};

#endif // !defined(AFX_ANALOGDEVICEVIDEOGRAPH_H__AE76E803_E285_4895_B23A_D1E837862578__INCLUDED_)
