// AnimationFactoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimationFactory.h"
#include "AnimationFactoryDlg.h"
#include "CvvImage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg dialog

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

// OPENCV INITIALIZE
//
struct VideoBanny
{
	double dSampleTime;
	cv::Mat1b y;
	cv::Mat1b u;
	cv::Mat1b v;
};


// VIDEO EVENT
//
HANDLE gVideoDataEvent = NULL;
CRITICAL_SECTION gVideoDataCS;
VideoBanny gVideoData;

BYTE	*DstFrameBuff;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_detected_callback( %d )", i );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_removed_callback( %d )", i );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = nVideoWidth;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = nVideoHeight;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = nAudioChannels;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = nAudioBitsPerSample;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %d, %d, %d )", i, nVideoWidth, nVideoHeight, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);
	
	if (g_pAnimationFactoryDlg->b_nBanny == true) {

	if(pFrameBuffer == NULL || nFrameBufferLen == 0)
		return QCAP_RT_OK;

	if (g_pAnimationFactoryDlg->m_pDevices[ i ])
	{
	QCAP_COLORSPACE_YUY2_TO_YV12( pFrameBuffer, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ], g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ], 0, DstFrameBuff, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ], g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ], 0 );
	}

	cv::Mat1b y(g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ], g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ]);
	cv::Mat1b u(g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] / 2, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] / 2);
	cv::Mat1b v(g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] / 2, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] / 2);

	{			
		uchar* src = DstFrameBuff;
		cv::Mat1b(g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ], g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ], src, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ]).copyTo(y);
		
		src += g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] * g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ];
		cv::Mat1b(g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] / 2, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] / 2, src, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] / 2).copyTo(u);

		src += g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] * g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ];
		cv::Mat1b(g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] / 2, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] / 2, src, g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] / 2).copyTo(v);
	}

	EnterCriticalSection(&gVideoDataCS);
	{
		gVideoData.dSampleTime = dSampleTime;
		gVideoData.y = y;
		gVideoData.u = u;
		gVideoData.v = v;
		SetEvent(gVideoDataEvent);
	}
	LeaveCriticalSection(&gVideoDataCS);
	}
    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

    return (QRETURN)(QCAP_RT_SKIP_DISPLAY | QCAP_RT_SKIP_CLONE_DISPLAY);
}

CAnimationFactoryDlg::CAnimationFactoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationFactoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimationFactoryDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimationFactoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimationFactoryDlg)
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_0, m_statChannelWindow0);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_1, m_statBannyWindow);
}

BEGIN_MESSAGE_MAP(CAnimationFactoryDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimationFactoryDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_BANNY, &CAnimationFactoryDlg::OnBnClickedButtonBanny)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg message handlers

extern CAnimationFactoryApp theApp;

void CAnimationFactoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	KillTimer( 0x00000001 );

	// UNINITIALIZE DEVICE RESOURCE
	// 
	for( ULONG i = 0 ; i < 1 ; i++ ) {

		if( m_pDevices[ i ] ) {

			QCAP_STOP( m_pDevices[ i ] );

			QCAP_DESTROY( m_pDevices[ i ] );

			m_pDevices[ i ] = NULL;
		}
	}
	
	DeleteCriticalSection(&gVideoDataCS);
	CloseHandle(gVideoDataEvent);

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

BOOL CAnimationFactoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE DEVICE RESOURCE
	// 
	g_pAnimationFactoryDlg = this;

	for( ULONG i = 0 ; i < 1 ; i++ ) {
		
		m_pDevices[ i ] = NULL;

		m_nDeviceVideoWidths[ i ] = 0;

		m_nDeviceVideoHeights[ i ] = 0;

		m_nDeviceAudioChannels[ i ] = 0;

		m_nDeviceAudioBitsPerSamples[ i ] = 0;

		m_nDeviceAudioSampleFrequencys[ i ] = 0;

		b_nBanny = false;
	}

	gVideoDataEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	InitializeCriticalSection(&gVideoDataCS);

	DstFrameBuff = (BYTE*)malloc(sizeof(BYTE)*(1920*1080*4) );

	// INITIALIZE DEVICE RESOURCE
	// 
	QCAP_CREATE( "SA7160 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], TRUE );

	for(ULONG i = 0 ; i < 1 ; i++ ) {

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevices[ i ], on_format_changed_callback, (PVOID)(i) );

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevices[ i ], on_no_signal_detected_callback, (PVOID)(i) );

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevices[ i ], on_no_signal_removed_callback, (PVOID)(i) );

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevices[ i ], on_video_preview_callback, (PVOID)(i) );

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevices[ i ], on_audio_preview_callback, (PVOID)(i) );

		QCAP_RUN( m_pDevices[ i ] );
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimationFactoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimationFactoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimationFactoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAnimationFactoryDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CAnimationFactoryDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}


void CAnimationFactoryDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	CDialog::OnTimer(nIDEvent);

	if ( nIDEvent == 0x00000001 ) {

		cv::Mat3b m(300, 300);

		m.setTo(cv::Vec3b(255, 0, 0));

		HANDLE pEvents[] = { gVideoDataEvent };

		while(true)
		{
		
			DWORD res = WaitForMultipleObjects(_countof(pEvents), pEvents, FALSE, 4);
		
			if(res == WAIT_OBJECT_0) // video
			{
	
				VideoBanny data;

				VideoBanny dataBanny;

				EnterCriticalSection(&gVideoDataCS);
				std::swap(data, gVideoData);
				LeaveCriticalSection(&gVideoDataCS);

				//2014.10.30
				//
				cv::Canny(data.y, dataBanny.y, 50, 70, 3 );

				IplImage img = dataBanny.y;

				DrawPicToHDC(&img, IDC_STATIC_CHANNEL_WINDOW_1);

				break;
			}
			else if(res == WAIT_FAILED)
				break;
				int ch = cv::waitKey(8);
				if(ch == 27)
				break;
		}
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonBanny()
{
	// TODO: Add your control notification handler code here

	b_nBanny = true;

	SetTimer( 0x00000001, 120, NULL );
}

void CAnimationFactoryDlg::DrawPicToHDC(IplImage *img, UINT ID)
{

	CDC *pDC = GetDlgItem(ID)->GetDC();

	HDC hDC= pDC->GetSafeHdc();

	CRect rect;

	GetDlgItem(ID)->GetClientRect(&rect);

	CvvImage cimg;

	cimg.CopyOf( img );

	cimg.DrawToHDC( hDC, &rect ); 

	ReleaseDC( pDC );

}
