unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActiveX, QCAP.DELPHI;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  g_pDevice: PVOID;


implementation

{$R *.dfm}

function FORMAT_CHANGED_CALLBACK(pDevice: PVOID;
                                 nVideoInput: ULONG;
                                 nAudioInput: ULONG;
                                 nVideoWidth: ULONG;
                                 nVideoHeight: ULONG;
                                 bVideoIsInterleaved: BOOL;
                                 nVideoFrameRate: ULONG;
                                 nAudioChannels: ULONG;
                                 nAudioBitsPerSample: ULONG;
                                 nAudioSampleFrequency: ULONG;
                                 pUserData: PVOID): QRETURN; cdecl;

begin

  Result := QCAP_RT_OK;

end;


function VIDEO_PREVIEW_CALLBACK (pDevice: PVOID;
                                 dSampleTime: Double;
                                 pFrameBuffer: Pbyte;
                                 nFrameBufferLen: ULONG;
                                 pUserData: PVOID): QRETURN; cdecl;

begin

  Result := QCAP_RT_OK;

end;

function AUDIO_PREVIEW_CALLBACK( pDevice: PVOID;
                                 dSampleTime: Double;
                                 pFrameBuffer: Pbyte;
                                 nFrameBufferLen: ULONG;
                                 pUserData: PVOID): QRETURN; cdecl;

begin

  Result := QCAP_RT_OK;

end;


procedure TForm1.FormCreate(Sender: TObject);
var

  strDevName: ASTRING;
  psz: PCHAR;
  iDevNum: ULONG;
  hAttachedWindow : HWND;
  bThumbDraw: BOOL;
  bMaintainAspectRatio: BOOL;
  qr : QRESULT;

begin

  iDevNum := 0;

  hAttachedWindow := Form1.Handle;

  strDevName := 'SA7160 PCI';

  psz := addr( strDevName[ 1 ] );

  bThumbDraw := False;

  bMaintainAspectRatio := False;

  qr :=  QCAP_RS_SUCCESSFUL;

  qr := QCAP_CREATE( psz, iDevNum, hAttachedWindow, g_pDevice, bThumbDraw, bMaintainAspectRatio );

  qr := QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( g_pDevice, @FORMAT_CHANGED_CALLBACK, Form1 );

  // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
  //
  qr := QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( g_pDevice, @VIDEO_PREVIEW_CALLBACK, Form1 );

  // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
  //
  qr := QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( g_pDevice, @AUDIO_PREVIEW_CALLBACK, Form1 );

  qr := QCAP_RUN( g_pDevice );

end;



procedure TForm1.FormDestroy(Sender: TObject);
var

  qr : QRESULT;

begin

  qr := QCAP_STOP( g_pDevice );

  qr := QCAP_RS_SUCCESSFUL;

  qr := QCAP_DESTROY ( g_pDevice );

  g_pDevice := nil;

end;

initialization

  ActiveX.CoInitialize(nil);

finalization

  ActiveX.CoUninitialize;

end.
